/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class AndroidLintParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> issues = ViolationParserUtils.getChunks(string, "<issue", "</issue>");
        for (String issueChunk : issues) {
            String location = ViolationParserUtils.getChunks(issueChunk, "<location", "/>").get(0);
            String filename = ViolationParserUtils.getAttribute(location, "file");
            Optional<Integer> line = ViolationParserUtils.findIntegerAttribute(location, "line");
            Optional<Integer> charAttrib = ViolationParserUtils.findIntegerAttribute(location, "column");
            String severity = ViolationParserUtils.getAttribute(issueChunk, "severity");
            String id = ViolationParserUtils.getAttribute(issueChunk, "id");
            String message = ViolationParserUtils.getAttribute(issueChunk, "message");
            String summary = ViolationParserUtils.getAttribute(issueChunk, "summary").trim();
            String explanation = ViolationParserUtils.getAttribute(issueChunk, "explanation");
            String rule = ViolationParserUtils.getAttribute(issueChunk, "category");
            violations.add(Violation.violationBuilder().setParser(Parser.ANDROIDLINT).setStartLine(line.or(0)).setColumn(charAttrib.orNull()).setFile(filename).setSeverity(this.toSeverity(severity)).setRule(rule).setMessage(id + ": " + summary + "\n" + message + "\n" + explanation).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

