/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CheckStyleParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> files = ViolationParserUtils.getChunks(string, "<file", "</file>");
        for (String fileChunk : files) {
            String filename = ViolationParserUtils.getAttribute(fileChunk, "name");
            List<String> errors = ViolationParserUtils.getChunks(fileChunk, "<error", "/>");
            for (String errorChunk : errors) {
                Integer line = ViolationParserUtils.getIntegerAttribute(errorChunk, "line");
                Optional<Integer> column = ViolationParserUtils.findIntegerAttribute(errorChunk, "column");
                String severity = ViolationParserUtils.getAttribute(errorChunk, "severity");
                String message = ViolationParserUtils.getAttribute(errorChunk, "message");
                String rule = ViolationParserUtils.findAttribute(errorChunk, "source").orNull();
                violations.add(Violation.violationBuilder().setParser(Parser.CHECKSTYLE).setStartLine(line).setColumn(column.orNull()).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).setRule(rule).build());
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

