/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CodeNarcParser
implements ViolationsParser {
    private SEVERITY getSeverity(Integer from) {
        if (from == 1) {
            return SEVERITY.ERROR;
        }
        if (from == 2) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        XMLStreamReader xmlr;
        XMLInputFactory factory;
        ArrayList<Violation> violations = new ArrayList<Violation>();
        HashMap<String, String> rules = new HashMap<String, String>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            factory = XMLInputFactory.newInstance();
            xmlr = factory.createXMLStreamReader(input);
            String name = null;
            String description = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("Rule")) {
                    name = ViolationParserUtils.getAttribute(xmlr, "name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("Description")) continue;
                description = xmlr.getElementText().trim();
                rules.put(name, description);
            }
        }
        input = new ByteArrayInputStream(string.getBytes("UTF-8"));
        var5_5 = null;
        try {
            factory = XMLInputFactory.newInstance();
            xmlr = factory.createXMLStreamReader(input);
            String path = null;
            String name = null;
            String ruleName = null;
            Integer priority = null;
            Integer lineNumber = null;
            while (xmlr.hasNext()) {
                String message;
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("Package")) {
                    path = ViolationParserUtils.getAttribute(xmlr, "path");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("File")) {
                    name = ViolationParserUtils.getAttribute(xmlr, "name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("Violation")) continue;
                ruleName = ViolationParserUtils.getAttribute(xmlr, "ruleName");
                priority = ViolationParserUtils.getIntegerAttribute(xmlr, "priority");
                String lineNumberString = ViolationParserUtils.getAttribute(xmlr, "lineNumber");
                lineNumber = 1;
                if (!lineNumberString.isEmpty()) {
                    lineNumber = Integer.parseInt(lineNumberString);
                }
                if ((message = (String)rules.get(ruleName)) == null) {
                    message = ruleName;
                }
                Violation violation = Violation.violationBuilder().setParser(Parser.CODENARC).setFile(path + "/" + name).setMessage(message).setRule(ruleName).setSeverity(this.getSeverity(priority)).setStartLine(lineNumber).build();
                violations.add(violation);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (input != null) {
                if (var5_5 != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    ((InputStream)input).close();
                }
            }
        }
        return violations;
    }
}

