/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CppLintParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> lines = ViolationParserUtils.getLines(string);
        for (String line : lines) {
            List<String> parts = ViolationParserUtils.getParts(line, "\\[([^\\]]*)\\]$", "\\[([^\\]]*)\\]$", "^([^:]*):", "^([^:]*):", "(.*)");
            if (parts.isEmpty()) continue;
            Integer severity = Integer.parseInt(parts.get(0));
            String rule = parts.get(1);
            String filename = parts.get(2);
            Integer lineNumber = Integer.parseInt(parts.get(3));
            String message = parts.get(4);
            violations.add(Violation.violationBuilder().setParser(Parser.CPPLINT).setStartLine(lineNumber).setFile(filename).setRule(rule).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(Integer severity) {
        if (severity >= 5) {
            return SEVERITY.ERROR;
        }
        if (severity >= 3) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

