/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class FindbugsParser
implements ViolationsParser {
    private static Logger LOG = Logger.getLogger(FindbugsParser.class.getSimpleName());
    public static final String FINDBUGS_SPECIFIC_RANK = "RANK";
    private static String findbugsMessagesXml;

    public static void setFindbugsMessagesXml(String findbugsMessagesXml) {
        FindbugsParser.findbugsMessagesXml = findbugsMessagesXml;
    }

    private Map<String, String> getMessagesPerType() {
        HashMap<String, String> messagesPerType = new HashMap<String, String>();
        try {
            if (Utils.isNullOrEmpty(findbugsMessagesXml)) {
                String messagesResourceFilename = "/findbugs/messages.xml";
                URL resource = FindbugsParser.class.getResource("/findbugs/messages.xml");
                if (resource == null) {
                    throw new RuntimeException("Unable to find resource /findbugs/messages.xml");
                }
                findbugsMessagesXml = Utils.toString(resource);
            }
            List<String> bugPatterns = ViolationParserUtils.getChunks(findbugsMessagesXml, "<BugPattern", "</BugPattern>");
            for (String bugPattern : bugPatterns) {
                String type = ViolationParserUtils.getAttribute(bugPattern, "type");
                String shortDescription = ViolationParserUtils.getContent(bugPattern, "ShortDescription");
                String details = ViolationParserUtils.getContent(bugPattern, "Details");
                messagesPerType.put(type, shortDescription + "\n\n" + details);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return messagesPerType;
    }

    private void parseBugInstance(XMLStreamReader xmlr, List<Violation> violations, Map<String, String> messagesPerType) throws XMLStreamException {
        String type = ViolationParserUtils.getAttribute(xmlr, "type");
        Integer rank = ViolationParserUtils.getIntegerAttribute(xmlr, "rank");
        String message = messagesPerType.get(type);
        if (message == null) {
            message = type;
        }
        SEVERITY severity = this.toSeverity(rank);
        ArrayList<Violation> candidates = new ArrayList<Violation>();
        while (xmlr.hasNext()) {
            int eventType = xmlr.next();
            if (eventType == 1 && xmlr.getLocalName().equalsIgnoreCase("SourceLine")) {
                Optional<Integer> startLine = ViolationParserUtils.findIntegerAttribute(xmlr, "start");
                Optional<Integer> endLine = ViolationParserUtils.findIntegerAttribute(xmlr, "end");
                if (!startLine.isPresent() || !endLine.isPresent()) continue;
                String filename = ViolationParserUtils.getAttribute(xmlr, "sourcepath");
                String classname = ViolationParserUtils.getAttribute(xmlr, "classname");
                candidates.add(Violation.violationBuilder().setParser(Parser.FINDBUGS).setMessage(message).setFile(filename).setStartLine(startLine.get()).setEndLine(endLine.get()).setRule(type).setSeverity(severity).setSource(classname).setSpecific(FINDBUGS_SPECIFIC_RANK, rank).build());
            }
            if (eventType != 2 || !xmlr.getLocalName().equalsIgnoreCase("BugInstance")) continue;
            break;
        }
        if (!candidates.isEmpty()) {
            violations.add((Violation)candidates.get(candidates.size() - 1));
        }
    }

    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        Map<String, String> messagesPerType = this.getMessagesPerType();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1 || !xmlr.getLocalName().equalsIgnoreCase("BugInstance")) continue;
                this.parseBugInstance(xmlr, violations, messagesPerType);
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(Integer rank) {
        if (rank <= 9) {
            return SEVERITY.ERROR;
        }
        if (rank <= 14) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

