/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class FxCopParser
implements ViolationsParser {
    private static Logger LOG = Logger.getLogger(FxCopParser.class.getSimpleName());

    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(input);
            String targetName = null;
            String typeName = null;
            String classname = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("Target")) {
                    targetName = ViolationParserUtils.getAttribute(xmlr, "Name").replaceAll("\\\\", "/");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("Message")) {
                    typeName = ViolationParserUtils.getAttribute(xmlr, "TypeName");
                }
                if (xmlr.getLocalName().equalsIgnoreCase("Type")) {
                    classname = ViolationParserUtils.getAttribute(xmlr, "Name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("Issue")) continue;
                String level = ViolationParserUtils.getAttribute(xmlr, "Level");
                Optional<String> path = ViolationParserUtils.findAttribute(xmlr, "Path");
                if (!path.isPresent()) {
                    LOG.log(Level.FINE, "Ignoring project level issue");
                    continue;
                }
                String fileName = ViolationParserUtils.getAttribute(xmlr, "File");
                Integer line = ViolationParserUtils.getIntegerAttribute(xmlr, "Line");
                String message = xmlr.getElementText().replaceAll("\\s+", " ");
                String filename = path.get() + "/" + fileName;
                SEVERITY severity = this.toSeverity(level);
                violations.add(Violation.violationBuilder().setParser(Parser.FXCOP).setMessage(message).setFile(filename).setStartLine(line).setRule(typeName).setSeverity(severity).setSource(classname).setSpecific("TARGET_NAME", targetName).build());
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(String issueLevel) {
        if (issueLevel.contains("CriticalError")) {
            return SEVERITY.ERROR;
        }
        if (issueLevel.contains("Error")) {
            return SEVERITY.ERROR;
        }
        if (issueLevel.contains("CriticalWarning")) {
            return SEVERITY.WARN;
        }
        if (issueLevel.contains("Warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

