/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class MyPyParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String reportContent) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "^(.*):(\\d+): (.*): (.*)$");
        for (List<String> parts : partsPerLine) {
            String fileName = parts.get(1);
            Integer lineNumber = 0;
            if (!parts.get(2).isEmpty()) {
                lineNumber = Integer.parseInt(parts.get(2));
            }
            String severity = parts.get(3);
            String message = parts.get(4);
            violations.add(Violation.violationBuilder().setParser(Parser.MYPY).setStartLine(lineNumber).setFile(fileName).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        return SEVERITY.INFO;
    }
}

