/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Optional;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class PMDParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> files = ViolationParserUtils.getChunks(string, "<file", "</file>");
        for (String fileChunk : files) {
            String filename = ViolationParserUtils.getAttribute(fileChunk, "name");
            List<String> violationsChunks = ViolationParserUtils.getChunks(fileChunk, "<violation", "</violation>");
            for (String violationChunk : violationsChunks) {
                Integer beginLine = ViolationParserUtils.getIntegerAttribute(violationChunk, "beginline");
                Integer endLine = ViolationParserUtils.getIntegerAttribute(violationChunk, "endline");
                Optional<Integer> beginColumn = ViolationParserUtils.findIntegerAttribute(violationChunk, "begincolumn");
                String rule = ViolationParserUtils.getAttribute(violationChunk, "rule").trim();
                Optional<String> ruleSetOpt = ViolationParserUtils.findAttribute(violationChunk, "ruleset");
                Optional<String> externalInfoUrlOpt = ViolationParserUtils.findAttribute(violationChunk, "externalInfoUrl");
                Integer priority = ViolationParserUtils.getIntegerAttribute(violationChunk, "priority");
                SEVERITY severity = this.toSeverity(priority);
                String content = ViolationParserUtils.getContent(violationChunk, "violation");
                String message = content + "\n\n" + ruleSetOpt.or("") + " " + externalInfoUrlOpt.or("");
                violations.add(Violation.violationBuilder().setParser(Parser.PMD).setStartLine(beginLine).setEndLine(endLine).setColumn(beginColumn.orNull()).setFile(filename).setSeverity(severity).setRule(rule).setMessage(message.trim()).build());
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(Integer priority) {
        if (priority < 3) {
            return SEVERITY.ERROR;
        }
        if (priority < 5) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

