/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class StyleCopParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes("UTF-8"));){
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader xmlr = factory.createXMLStreamReader(input);
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1 || !xmlr.getLocalName().equalsIgnoreCase("Violation")) continue;
                String section = ViolationParserUtils.getAttribute(xmlr, "Section");
                String source = ViolationParserUtils.getAttribute(xmlr, "Source");
                String ruleNamespace = ViolationParserUtils.getAttribute(xmlr, "RuleNamespace");
                String rule = ViolationParserUtils.getAttribute(xmlr, "Rule");
                String ruleId = ViolationParserUtils.getAttribute(xmlr, "RuleId");
                Integer lineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "LineNumber");
                String message = xmlr.getElementText().replaceAll("\\s+", " ");
                SEVERITY severity = SEVERITY.INFO;
                String filename = source.replaceAll("\\\\", "/");
                violations.add(Violation.violationBuilder().setParser(Parser.STYLECOP).setMessage(message).setFile(filename).setStartLine(lineNumber).setRule(rule).setSeverity(severity).setSource(filename).setSpecific("section", section).setSpecific("source", source).setSpecific("ruleNamespace", ruleNamespace).setSpecific("rule", rule).setSpecific("ruleId", ruleId).build());
            }
        }
        return violations;
    }
}

