/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class XMLLintParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<String> lines = ViolationParserUtils.getLines(string);
        for (String line : lines) {
            List<String> parts = ViolationParserUtils.getParts(line, "^([^:]*):", "^([^:]*):", "^([^:]*):", "(.*)");
            if (parts.isEmpty()) continue;
            String filename = parts.get(0);
            Integer lineNumber = Integer.parseInt(parts.get(1));
            String rule = parts.get(2);
            String message = parts.get(3);
            violations.add(Violation.violationBuilder().setParser(Parser.XMLLINT).setStartLine(lineNumber).setFile(filename).setRule(rule).setSeverity(SEVERITY.ERROR).setMessage(message).build());
        }
        return violations;
    }
}

