/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.reports;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class ReportsFinder {
    public static List<File> findAllReports(File startFile, final String pattern) {
        final ArrayList<File> found = new ArrayList<File>();
        Path startPath = startFile.toPath();
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String absoluteFile = file.toFile().getAbsolutePath();
                    if (Pattern.matches(pattern, absoluteFile)) {
                        found.add(file.toFile());
                    }
                    return super.visitFile(file, attrs);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(found);
        return found;
    }
}

