/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.apache.http.client.protocol;

import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpEntity;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpEntityEnclosingRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpException;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequest;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpRequestInterceptor;
import se.bjurr.violations.violationsgitlib.org.apache.http.HttpVersion;
import se.bjurr.violations.violationsgitlib.org.apache.http.ProtocolVersion;
import se.bjurr.violations.violationsgitlib.org.apache.http.annotation.Immutable;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.config.RequestConfig;
import se.bjurr.violations.violationsgitlib.org.apache.http.client.protocol.HttpClientContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.protocol.HttpContext;
import se.bjurr.violations.violationsgitlib.org.apache.http.util.Args;

@Immutable
public class RequestExpectContinue
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

