/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.AbortedByHookException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.NoHeadException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.NoMessageException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.UnmergedPathsException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCache;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheBuildIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheEntry;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.FileMode;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.PersonIdent;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.RepositoryState;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevObject;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevTag;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.CanonicalTreeParser;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.FileTreeIterator;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.treewalk.TreeWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.ChangeIdUtil;

public class CommitCommand
extends GitCommand<RevCommit> {
    private PersonIdent author;
    private PersonIdent committer;
    private String message;
    private boolean all;
    private List<String> only = new ArrayList<String>();
    private boolean[] onlyProcessed;
    private boolean amend;
    private boolean insertChangeId;
    private List<ObjectId> parents = new LinkedList<ObjectId>();
    private String reflogComment;
    private boolean useDefaultReflogMessage = true;
    private boolean noVerify;
    private HashMap<String, PrintStream> hookOutRedirect = new HashMap(3);
    private Boolean allowEmpty;

    protected CommitCommand(Repository repo) {
        super(repo);
    }

    /*
     * Exception decompiling
     */
    @Override
    public RevCommit call() throws GitAPIException, NoHeadException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, AbortedByHookException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 14[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void insertChangeId(ObjectId treeId) {
        ObjectId firstParentId = null;
        if (!this.parents.isEmpty()) {
            firstParentId = this.parents.get(0);
        }
        ObjectId changeId = ChangeIdUtil.computeChangeId(treeId, firstParentId, this.author, this.committer, this.message);
        this.message = ChangeIdUtil.insertId(this.message, changeId);
        if (changeId != null) {
            this.message = this.message.replaceAll("\nChange-Id: I" + ObjectId.zeroId().getName() + "\n", "\nChange-Id: I" + changeId.getName() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirCache createTemporaryIndex(ObjectId headId, DirCache index, RevWalk rw) throws IOException {
        ObjectInserter inserter = null;
        DirCacheBuilder existingBuilder = index.builder();
        DirCache inCoreIndex = DirCache.newInCore();
        DirCacheBuilder tempBuilder = inCoreIndex.builder();
        this.onlyProcessed = new boolean[this.only.size()];
        boolean emptyCommit = true;
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.setOperationType(TreeWalk.OperationType.CHECKIN_OP);
            int dcIdx = treeWalk.addTree(new DirCacheBuildIterator(existingBuilder));
            FileTreeIterator fti = new FileTreeIterator(this.repo);
            fti.setDirCacheIterator(treeWalk, 0);
            int fIdx = treeWalk.addTree(fti);
            int hIdx = -1;
            if (headId != null) {
                hIdx = treeWalk.addTree(rw.parseTree(headId));
            }
            treeWalk.setRecursive(true);
            String lastAddedFile = null;
            while (treeWalk.next()) {
                String path = treeWalk.getPathString();
                int pos = this.lookupOnly(path);
                CanonicalTreeParser hTree = null;
                if (hIdx != -1) {
                    hTree = treeWalk.getTree(hIdx, CanonicalTreeParser.class);
                }
                DirCacheIterator dcTree = treeWalk.getTree(dcIdx, DirCacheIterator.class);
                if (pos >= 0) {
                    FileTreeIterator fTree = treeWalk.getTree(fIdx, FileTreeIterator.class);
                    boolean tracked = dcTree != null || hTree != null;
                    if (!tracked || path.equals(lastAddedFile)) continue;
                    lastAddedFile = path;
                    if (fTree != null) {
                        boolean objectExists;
                        DirCacheEntry dcEntry = new DirCacheEntry(path);
                        long entryLength = fTree.getEntryLength();
                        dcEntry.setLength(entryLength);
                        dcEntry.setLastModified(fTree.getEntryLastModified());
                        dcEntry.setFileMode(fTree.getIndexFileMode(dcTree));
                        boolean bl = objectExists = dcTree != null && fTree.idEqual(dcTree) || hTree != null && fTree.idEqual(hTree);
                        if (objectExists) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else if (FileMode.GITLINK.equals(dcEntry.getFileMode())) {
                            dcEntry.setObjectId(fTree.getEntryObjectId());
                        } else {
                            if (inserter == null) {
                                inserter = this.repo.newObjectInserter();
                            }
                            long contentLength = fTree.getEntryContentLength();
                            try (InputStream inputStream = fTree.openEntryStream();){
                                dcEntry.setObjectId(inserter.insert(3, contentLength, inputStream));
                            }
                        }
                        existingBuilder.add(dcEntry);
                        tempBuilder.add(dcEntry);
                        if (emptyCommit && (hTree == null || !hTree.idEqual(fTree) || hTree.getEntryRawMode() != fTree.getEntryRawMode())) {
                            emptyCommit = false;
                        }
                    } else if (emptyCommit && hTree != null) {
                        emptyCommit = false;
                    }
                    this.onlyProcessed[pos] = true;
                    continue;
                }
                if (hTree != null) {
                    DirCacheEntry dcEntry = new DirCacheEntry(path);
                    dcEntry.setObjectId(hTree.getEntryObjectId());
                    dcEntry.setFileMode(hTree.getEntryFileMode());
                    tempBuilder.add(dcEntry);
                }
                if (dcTree == null) continue;
                existingBuilder.add(dcTree.getDirCacheEntry());
            }
        }
        for (int i = 0; i < this.onlyProcessed.length; ++i) {
            if (this.onlyProcessed[i]) continue;
            throw new JGitInternalException(MessageFormat.format(JGitText.get().entryNotFoundByPath, this.only.get(i)));
        }
        if (emptyCommit && !this.allowEmpty.booleanValue()) {
            throw new JGitInternalException(JGitText.get().emptyCommit);
        }
        existingBuilder.commit();
        tempBuilder.finish();
        return inCoreIndex;
    }

    private int lookupOnly(String pathString) {
        String p = pathString;
        while (true) {
            int position;
            if ((position = Collections.binarySearch(this.only, p)) >= 0) {
                return position;
            }
            int l = p.lastIndexOf("/");
            if (l < 1) break;
            p = p.substring(0, l);
        }
        return -1;
    }

    private void processOptions(RepositoryState state, RevWalk rw) throws NoMessageException {
        if (this.committer == null) {
            this.committer = new PersonIdent(this.repo);
        }
        if (this.author == null && !this.amend) {
            this.author = this.committer;
        }
        if (this.allowEmpty == null) {
            Boolean bl = this.allowEmpty = this.only.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (state == RepositoryState.MERGING_RESOLVED || this.isMergeDuringRebase(state)) {
            try {
                this.parents = this.repo.readMergeHeads();
                if (this.parents != null) {
                    for (int i = 0; i < this.parents.size(); ++i) {
                        RevObject ro = rw.parseAny(this.parents.get(i));
                        if (!(ro instanceof RevTag)) continue;
                        this.parents.set(i, rw.peel(ro));
                    }
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
            }
            if (this.message == null) {
                try {
                    this.message = this.repo.readMergeCommitMsg();
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
                }
            }
        } else if (state == RepositoryState.SAFE && this.message == null) {
            try {
                this.message = this.repo.readSquashCommitMsg();
                if (this.message != null) {
                    this.repo.writeSquashCommitMsg(null);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_MSG", e), e);
            }
        }
        if (this.message == null) {
            throw new NoMessageException(JGitText.get().commitMessageNotSpecified);
        }
    }

    private boolean isMergeDuringRebase(RepositoryState state) {
        if (state != RepositoryState.REBASING_INTERACTIVE && state != RepositoryState.REBASING_MERGE) {
            return false;
        }
        try {
            return this.repo.readMergeHeads() != null;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringReadingOfGIT_DIR, "MERGE_HEAD", e), e);
        }
    }

    public CommitCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public CommitCommand setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public CommitCommand setCommitter(PersonIdent committer) {
        this.checkCallable();
        this.committer = committer;
        return this;
    }

    public CommitCommand setCommitter(String name, String email) {
        this.checkCallable();
        return this.setCommitter(new PersonIdent(name, email));
    }

    public PersonIdent getCommitter() {
        return this.committer;
    }

    public CommitCommand setAuthor(PersonIdent author) {
        this.checkCallable();
        this.author = author;
        return this;
    }

    public CommitCommand setAuthor(String name, String email) {
        this.checkCallable();
        return this.setAuthor(new PersonIdent(name, email));
    }

    public PersonIdent getAuthor() {
        return this.author;
    }

    public CommitCommand setAll(boolean all) {
        this.checkCallable();
        if (all && !this.only.isEmpty()) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--all", "--only"));
        }
        this.all = all;
        return this;
    }

    public CommitCommand setAmend(boolean amend) {
        this.checkCallable();
        this.amend = amend;
        return this;
    }

    public CommitCommand setOnly(String only) {
        String o;
        this.checkCallable();
        if (this.all) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().illegalCombinationOfArguments, "--only", "--all"));
        }
        String string = o = only.endsWith("/") ? only.substring(0, only.length() - 1) : only;
        if (!this.only.contains(o)) {
            this.only.add(o);
        }
        return this;
    }

    public CommitCommand setInsertChangeId(boolean insertChangeId) {
        this.checkCallable();
        this.insertChangeId = insertChangeId;
        return this;
    }

    public CommitCommand setReflogComment(String reflogComment) {
        this.reflogComment = reflogComment;
        this.useDefaultReflogMessage = false;
        return this;
    }

    public CommitCommand setNoVerify(boolean noVerify) {
        this.noVerify = noVerify;
        return this;
    }

    public CommitCommand setHookOutputStream(PrintStream hookStdOut) {
        this.setHookOutputStream("pre-commit", hookStdOut);
        this.setHookOutputStream("se.bjurr.violations.violationsgitlib.commit-msg", hookStdOut);
        this.setHookOutputStream("post-commit", hookStdOut);
        return this;
    }

    public CommitCommand setHookOutputStream(String hookName, PrintStream hookStdOut) {
        if (!("pre-commit".equals(hookName) || "se.bjurr.violations.violationsgitlib.commit-msg".equals(hookName) || "post-commit".equals(hookName))) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().illegalHookName, hookName));
        }
        this.hookOutRedirect.put(hookName, hookStdOut);
        return this;
    }
}

