/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.LockFile;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Constants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FS;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FileUtils;

public class PackLock {
    private final File keepFile;

    public PackLock(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode(msg));
        return lf.commit();
    }

    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

