/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.TransportException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Constants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectIdRef;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ProgressMonitor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Ref;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport.URIish;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.IO;

abstract class WalkRemoteObjectDatabase {
    static final String ROOT_DIR = "../";
    static final String INFO_PACKS = "info/packs";
    static final String INFO_ALTERNATES = "info/alternates";
    static final String INFO_HTTP_ALTERNATES = "info/http-alternates";
    static final String INFO_REFS = "../info/refs";

    WalkRemoteObjectDatabase() {
    }

    abstract URIish getURI();

    abstract Collection<String> getPackNames() throws IOException;

    abstract Collection<WalkRemoteObjectDatabase> getAlternates() throws IOException;

    abstract FileStream open(String var1) throws FileNotFoundException, IOException;

    abstract WalkRemoteObjectDatabase openAlternate(String var1) throws IOException;

    abstract void close();

    void deleteFile(String path) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().deletingNotSupported, path));
    }

    OutputStream writeFile(String path, ProgressMonitor monitor, String monitorTask) throws IOException {
        throw new IOException(MessageFormat.format(JGitText.get().writingNotSupported, path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeFile(String path, byte[] data) throws IOException {
        try (OutputStream os = this.writeFile(path, null, null);){
            os.write(data);
        }
    }

    void deleteRef(String name) throws IOException {
        this.deleteFile(ROOT_DIR + name);
    }

    void deleteRefLog(String name) throws IOException {
        this.deleteFile("../logs/" + name);
    }

    void writeRef(String name, ObjectId value) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream(41);
        value.copyTo(b);
        b.write(10);
        this.writeFile(ROOT_DIR + name, b.toByteArray());
    }

    void writeInfoPacks(Collection<String> packNames) throws IOException {
        StringBuilder w = new StringBuilder();
        for (String n : packNames) {
            w.append("P ");
            w.append(n);
            w.append('\n');
        }
        this.writeFile(INFO_PACKS, Constants.encodeASCII(w.toString()));
    }

    BufferedReader openReader(String path) throws IOException {
        InputStream is = this.open((String)path).in;
        return new BufferedReader(new InputStreamReader(is, Constants.CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<WalkRemoteObjectDatabase> readAlternates(String listPath) throws IOException {
        try (BufferedReader br = this.openReader(listPath);){
            String line;
            ArrayList<WalkRemoteObjectDatabase> alts = new ArrayList<WalkRemoteObjectDatabase>();
            while ((line = br.readLine()) != null) {
                if (!line.endsWith("/")) {
                    line = line + "/";
                }
                alts.add(this.openAlternate(line));
            }
            ArrayList<WalkRemoteObjectDatabase> arrayList = alts;
            return arrayList;
        }
    }

    protected void readPackedRefs(Map<String, Ref> avail) throws TransportException {
        try (BufferedReader br2 = this.openReader("../packed-refs");){
            this.readPackedRefsImpl(avail, br2);
        }
        catch (FileNotFoundException br2) {
        }
        catch (IOException e) {
            throw new TransportException(this.getURI(), JGitText.get().errorInPackedRefs, e);
        }
    }

    private void readPackedRefsImpl(Map<String, Ref> avail, BufferedReader br) throws IOException {
        String line;
        Ref last = null;
        boolean peeled = false;
        while ((line = br.readLine()) != null) {
            if (line.charAt(0) == '#') {
                if (!line.startsWith("# pack-refs with:")) continue;
                line = line.substring("# pack-refs with:".length());
                peeled = line.contains(" peeled");
                continue;
            }
            if (line.charAt(0) == '^') {
                if (last == null) {
                    throw new TransportException(JGitText.get().peeledLineBeforeRef);
                }
                ObjectId id = ObjectId.fromString(line.substring(1));
                last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                avail.put(last.getName(), last);
                continue;
            }
            int sp = line.indexOf(32);
            if (sp < 0) {
                throw new TransportException(MessageFormat.format(JGitText.get().unrecognizedRef, line));
            }
            ObjectId id = ObjectId.fromString(line.substring(0, sp));
            String name = line.substring(sp + 1);
            last = peeled ? new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id) : new ObjectIdRef.Unpeeled(Ref.Storage.PACKED, name, id);
            avail.put(last.getName(), last);
        }
    }

    static final class FileStream {
        final InputStream in;
        final long length;

        FileStream(InputStream i) {
            this.in = i;
            this.length = -1L;
        }

        FileStream(InputStream i, long n) {
            this.in = i;
            this.length = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] toArray() throws IOException {
            try {
                int n;
                if (this.length >= 0L) {
                    byte[] r = new byte[(int)this.length];
                    IO.readFully(this.in, r, 0, r.length);
                    byte[] byArray = r;
                    return byArray;
                }
                ByteArrayOutputStream r = new ByteArrayOutputStream();
                byte[] buf = new byte[2048];
                while ((n = this.in.read(buf)) >= 0) {
                    r.write(buf, 0, n);
                }
                byte[] byArray = r.toByteArray();
                return byArray;
            }
            finally {
                this.in.close();
            }
        }
    }
}

