/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.CommandFailedException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FS;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FileUtils;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.StringUtils;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.SystemReader;
import se.bjurr.violations.violationsgitlib.org.slf4j.Logger;
import se.bjurr.violations.violationsgitlib.org.slf4j.LoggerFactory;

public class FS_Win32
extends FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS_Win32.class);
    private volatile Boolean supportSymlinks;

    public FS_Win32() {
    }

    protected FS_Win32(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32(this);
    }

    @Override
    public boolean supportsExecute() {
        return false;
    }

    @Override
    public boolean canExecute(File f) {
        return false;
    }

    @Override
    public boolean setExecute(File f, boolean canExec) {
        return false;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean retryFailedLockFileCommit() {
        return true;
    }

    @Override
    protected File discoverGitExe() {
        String path = SystemReader.getInstance().getenv("PATH");
        File gitExe = FS_Win32.searchPath(path, "git.exe", "git.cmd");
        if (gitExe == null && FS_Win32.searchPath(path, "bash.exe") != null) {
            String w;
            try {
                w = FS_Win32.readPipe(this.userHome(), new String[]{"bash", "--login", "-c", "which git"}, Charset.defaultCharset().name());
            }
            catch (CommandFailedException e) {
                LOG.warn(e.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(w)) {
                gitExe = this.resolve(null, w);
            }
        }
        return gitExe;
    }

    @Override
    protected File userHomeImpl() {
        String homePath;
        String home = SystemReader.getInstance().getenv("HOME");
        if (home != null) {
            return this.resolve(null, home);
        }
        String homeDrive = SystemReader.getInstance().getenv("HOMEDRIVE");
        if (homeDrive != null && (homePath = SystemReader.getInstance().getenv("HOMEPATH")) != null) {
            return new File(homeDrive, homePath);
        }
        String homeShare = SystemReader.getInstance().getenv("HOMESHARE");
        if (homeShare != null) {
            return new File(homeShare);
        }
        return super.userHomeImpl();
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args) {
        ArrayList<String> argv = new ArrayList<String>(3 + args.length);
        argv.add("cmd.exe");
        argv.add("/c");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    public boolean supportsSymlinks() {
        if (this.supportSymlinks == null) {
            this.detectSymlinkSupport();
        }
        return Boolean.TRUE.equals(this.supportSymlinks);
    }

    private void detectSymlinkSupport() {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempsymlinktarget", "");
            File linkName = new File(tempFile.getParentFile(), "tempsymlink");
            this.createSymLink(linkName, tempFile.getPath());
            this.supportSymlinks = Boolean.TRUE;
            linkName.delete();
        }
        catch (IOException | InternalError | UnsupportedOperationException e) {
            this.supportSymlinks = Boolean.FALSE;
        }
        finally {
            if (tempFile != null) {
                try {
                    FileUtils.delete(tempFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public FS.Attributes getAttributes(File path) {
        return FileUtils.getFileAttributesBasic(this, path);
    }
}

