/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import se.bjurr.violations.lib.model.Violation;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
public final class ViolationUtils {
    private ViolationUtils() {
    }

    public static String relativePath(List<Path> allFiles, Violation v) {
        String file = v.getFile();
        return ViolationUtils.relativePath(allFiles, file, ViolationUtils.getUserDir());
    }

    static String relativePath(List<Path> allFiles, String file, String userDir) {
        String userDirNotNull = Optional.ofNullable(userDir).orElse("");
        String cwd = Violation.frontSlashes(userDirNotNull);
        String relativeToCwd = ViolationUtils.getFileRelativeToCwd(allFiles, file);
        return ViolationUtils.removeSlashAtBeginning(relativeToCwd, cwd);
    }

    private static String getFileRelativeToCwd(List<Path> allFound, String file) {
        if ((allFound = allFound.stream().filter(it -> it.toFile().getAbsolutePath().endsWith(file)).collect(Collectors.toList())).isEmpty() || allFound.size() > 1) {
            return file;
        }
        return allFound.get(0).toFile().getAbsolutePath();
    }

    private static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static List<Path> getAllFiles() {
        return ViolationUtils.getAllFiles(ViolationUtils.getUserDir());
    }

    public static List<Path> getAllFiles(String cwd) {
        List<Path> list;
        block9: {
            if (cwd == null) {
                return new ArrayList<Path>();
            }
            Stream<Path> stream = Files.walk(Paths.get(cwd, new String[0]), new FileVisitOption[0]);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new ArrayList<Path>();
                }
            }
            stream.close();
        }
        return list;
    }

    private static String removeSlashAtBeginning(String file, String cwd) {
        String cwdRemoved;
        if (file.equals("-")) {
            return file;
        }
        if (cwd == null || cwd.isEmpty()) {
            return ViolationUtils.removeAnySlashAtBeginning(file);
        }
        String fileRemoved = ViolationUtils.removeAnySlashAtBeginning(file);
        if (fileRemoved.startsWith(cwdRemoved = ViolationUtils.removeAnySlashAtBeginning(cwd))) {
            return ViolationUtils.removeAnySlashAtBeginning(fileRemoved.substring(cwdRemoved.length()));
        }
        return fileRemoved;
    }

    private static String removeAnySlashAtBeginning(String file) {
        if (file.startsWith("/")) {
            return file.substring(1);
        }
        return file;
    }
}

