/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model.codeclimate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateCategory;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateLocation;
import se.bjurr.violations.lib.model.codeclimate.CodeClimateSeverity;
import se.bjurr.violations.lib.util.Utils;

public class CodeClimate {
    private final String description;
    private final String fingerprint;
    private final CodeClimateLocation location;
    private final List<CodeClimateLocation> other_locations;
    private final CodeClimateSeverity severity;
    private final String type;
    private final List<String> categories;
    private final String check_name;
    private final String engine_name;

    public CodeClimate(String description, String fingerprint, CodeClimateLocation location, CodeClimateSeverity severity, String check_name, String engine_name, List<CodeClimateCategory> categories, List<CodeClimateLocation> other_locations) {
        this.description = Utils.checkNotNull(Utils.emptyToNull(description), "se.bjurr.violations.violationsgitlib.description");
        this.fingerprint = Utils.checkNotNull(Utils.emptyToNull(fingerprint), "fingerprint");
        this.location = Utils.checkNotNull(location, "location");
        this.other_locations = Utils.firstNonNull(other_locations, new ArrayList());
        this.severity = severity;
        this.type = "issue";
        this.check_name = check_name;
        this.engine_name = engine_name;
        this.categories = categories.stream().map(it -> it.getName()).collect(Collectors.toList());
    }

    public String getCheck_name() {
        return this.check_name;
    }

    public String getEngine_name() {
        return this.engine_name;
    }

    public List<CodeClimateCategory> getCategories() {
        return Arrays.asList(CodeClimateCategory.values()).stream().filter(it -> this.categories.contains(it.getName())).collect(Collectors.toList());
    }

    public String getType() {
        return this.type;
    }

    public CodeClimateSeverity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public CodeClimateLocation getLocation() {
        return this.location;
    }

    public List<CodeClimateLocation> getOther_locations() {
        return this.other_locations;
    }

    public String toString() {
        return "CodeClimate [description=" + this.description + ", fingerprint=" + this.fingerprint + ", location=" + this.location + ", severity=" + this.severity + ", type=" + this.type + ", categories=" + this.categories + ", check_name=" + this.check_name + ", engine_name=" + this.engine_name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.categories == null ? 0 : this.categories.hashCode());
        result = 31 * result + (this.check_name == null ? 0 : this.check_name.hashCode());
        result = 31 * result + (this.engine_name == null ? 0 : this.engine_name.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fingerprint == null ? 0 : this.fingerprint.hashCode());
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeClimate other = (CodeClimate)obj;
        if (this.categories == null ? other.categories != null : !this.categories.equals(other.categories)) {
            return false;
        }
        if (this.check_name == null ? other.check_name != null : !this.check_name.equals(other.check_name)) {
            return false;
        }
        if (this.engine_name == null ? other.engine_name != null : !this.engine_name.equals(other.engine_name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fingerprint == null ? other.fingerprint != null : !this.fingerprint.equals(other.fingerprint)) {
            return false;
        }
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

