/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class AnsibleLaterParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        return Arrays.asList(string.split("\\r?\\n|\\r")).stream().filter(it -> !it.trim().isEmpty()).map(it -> new Gson().fromJson((String)it, AnsibleLaterEntry.class)).map(it -> Violation.violationBuilder().setFile(it.later_file).setMessage(it.message).setParser(Parser.ANSIBLELATER).setRule(it.later_sid).setStartLine(it.later_lineno == null ? Violation.NO_LINE : it.later_lineno).setSeverity(this.toSeverity(it.levelname)).build()).collect(Collectors.toSet());
    }

    private SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("ERROR")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("WARNING")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    public static class AnsibleLaterEntry {
        public String asctime;
        public String levelname;
        public String message;
        public String later_tag;
        public String later_standard;
        public String later_file;
        public boolean later_passed;
        public String later_sid;
        public Integer later_lineno;
        public String later_message;
    }
}

