/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;

public class GoogleErrorProneParser
implements ViolationsParser {
    private static final String PATH_REGEX = "(([A-Z]:)?[^:]+?):(\\d+)";
    private static final String WARNING_REGEX = "([^:]+?): \\[([^]]+?)] (.*)";
    private static final Pattern NEW_VIOLATION = Pattern.compile("^(([A-Z]:)?[^:]+?):(\\d+): ([^:]+?): \\[([^]]+?)] (.*)$");

    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> found = new TreeSet<Violation>();
        String[] lines = reportContent.split("\n");
        block0: for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            Matcher matcher = NEW_VIOLATION.matcher(line);
            if (!matcher.find()) continue;
            String currentFilename = matcher.group(1).trim();
            int currentLine = Integer.parseInt(matcher.group(3));
            SEVERITY currentSeverity = this.toSeverity(matcher.group(4));
            String currentRule = matcher.group(5).trim();
            String currentRuleMessage = matcher.group(6).trim();
            StringBuilder currentMessage = new StringBuilder();
            for (int j = i + 1; j < lines.length; ++j) {
                line = lines[j];
                if (!line.startsWith("  ")) {
                    found.add(Violation.violationBuilder().setFile(currentFilename).setMessage(currentRuleMessage + "\n\n" + currentMessage.toString()).setParser(Parser.GOOGLEERRORPRONE).setRule(currentRule).setSeverity(currentSeverity).setStartLine(currentLine).build());
                    continue block0;
                }
                ++i;
                currentMessage.append(line.trim());
            }
        }
        return found;
    }

    private SEVERITY toSeverity(String from) {
        if (from.trim().equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (from.trim().equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

