/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.model.generated.sarif.MessageStrings;
import se.bjurr.violations.lib.model.generated.sarif.MultiformatMessageString;
import se.bjurr.violations.lib.model.generated.sarif.Notification;
import se.bjurr.violations.lib.model.generated.sarif.OriginalUriBaseIds;
import se.bjurr.violations.lib.model.generated.sarif.ReportingConfiguration;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.parsers.SarifParserOriginalUri;
import se.bjurr.violations.violationslib.com.google.gson.GsonBuilder;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializationContext;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializer;
import se.bjurr.violations.violationslib.com.google.gson.JsonElement;

public class SarifParserDeserializer {
    private static Logger LOGGER = Logger.getLogger(SarifParserDeserializer.class.getSimpleName());

    public static SarifSchema fromJson(String reportContent) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)Notification.Level.class), new NotificationDeserializer()).registerTypeAdapter((Type)((Object)ReportingConfiguration.Level.class), new ReportingConfigurationDeserializer()).registerTypeAdapter((Type)((Object)MessageStrings.class), new MessageStringsDeserializer()).registerTypeAdapter((Type)((Object)OriginalUriBaseIds.class), new SarifParserOriginalUri.OriginalUriBaseIdsStringsDeserializer()).create().fromJson(reportContent, SarifSchema.class);
    }

    private static class NotificationDeserializer
    implements JsonDeserializer<Notification.Level> {
        private NotificationDeserializer() {
        }

        @Override
        public Notification.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                String asString = json.getAsString();
                return Notification.Level.fromValue(asString);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, json.toString(), e);
                return Notification.Level.NONE;
            }
        }
    }

    private static class ReportingConfigurationDeserializer
    implements JsonDeserializer<ReportingConfiguration.Level> {
        private ReportingConfigurationDeserializer() {
        }

        @Override
        public ReportingConfiguration.Level deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                String asString = json.getAsString();
                return ReportingConfiguration.Level.fromValue(asString);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, json.toString(), e);
                return ReportingConfiguration.Level.NONE;
            }
        }
    }

    private static class MessageStringsDeserializer
    implements JsonDeserializer<MessageStrings> {
        private MessageStringsDeserializer() {
        }

        @Override
        public MessageStrings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                MessageStrings messageStrings = new MessageStrings();
                for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                    for (Map.Entry<String, JsonElement> valueEntry : entry.getValue().getAsJsonObject().entrySet()) {
                        MultiformatMessageString mv = new MultiformatMessageString();
                        mv.setText(valueEntry.getValue().getAsString());
                        messageStrings.getAdditionalProperties().put(entry.getKey(), mv);
                    }
                }
                return messageStrings;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, json.toString(), e);
                return new MessageStrings();
            }
        }
    }
}

