/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Optional;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.MultiformatMessageString;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptor;
import se.bjurr.violations.lib.parsers.SarifParser;
import se.bjurr.violations.lib.util.Utils;

public class SarifParserMessaging {
    static Optional<String> findMessageText(Message message) {
        if (message == null) {
            return Optional.empty();
        }
        String text = message.getMarkdown();
        if (Utils.isNullOrEmpty(text)) {
            text = message.getText();
        }
        return Optional.ofNullable(Utils.emptyToNull(text));
    }

    static String getMessageText(Message message, SarifParser.ParsedPhysicalLocation parsedPhysicalLocation, ReportingDescriptor reportingDescriptor) {
        String messageText;
        Optional<String> helpTextOpt;
        StringBuilder fullMessage = new StringBuilder();
        if (parsedPhysicalLocation != null && !Utils.isNullOrEmpty(parsedPhysicalLocation.regionMessage)) {
            fullMessage.append(parsedPhysicalLocation.regionMessage).append("\n\n");
        }
        if (reportingDescriptor != null) {
            Optional<String> shortDescriptionOpt;
            if (reportingDescriptor.getId() != null) {
                fullMessage.append(reportingDescriptor.getId());
            }
            if (!Utils.isNullOrEmpty(reportingDescriptor.getName())) {
                fullMessage.append(": ").append(reportingDescriptor.getName());
            }
            if ((shortDescriptionOpt = SarifParserMessaging.findMarkdownOrText(reportingDescriptor.getShortDescription())).isPresent()) {
                fullMessage.append("\n\n").append(shortDescriptionOpt.get());
            }
        }
        if ((helpTextOpt = SarifParserMessaging.findHelpText(reportingDescriptor)).isPresent()) {
            fullMessage.append("\n\nFor additional help see: ").append(helpTextOpt.get());
        }
        if (fullMessage.indexOf(messageText = SarifParserMessaging.getMessageText(message, reportingDescriptor)) < 0) {
            fullMessage.append("\n\n").append(messageText);
        }
        return fullMessage.toString().trim();
    }

    static String getMessageText(Message message, ReportingDescriptor reportingDescriptor) {
        Optional<String> textOpt = SarifParserMessaging.findMessageText(message);
        if (textOpt.isPresent()) {
            return textOpt.get();
        }
        Optional<String> renderedTextOpt = SarifParserMessaging.findRenderedReportingDescriptorText(message, reportingDescriptor);
        if (renderedTextOpt.isPresent()) {
            return renderedTextOpt.get();
        }
        if (reportingDescriptor != null && reportingDescriptor.getShortDescription() != null) {
            return reportingDescriptor.getShortDescription().toString();
        }
        return "";
    }

    private static Optional<String> findHelpText(ReportingDescriptor r) {
        if (r == null) {
            return Optional.empty();
        }
        Optional<String> foundOpt = SarifParserMessaging.findMarkdownOrText(r.getHelp(), r.getFullDescription());
        if (foundOpt.isPresent()) {
            return foundOpt;
        }
        return Optional.ofNullable(r.getName());
    }

    private static Optional<String> findRenderedReportingDescriptorText(Message message, ReportingDescriptor reportingDescriptor) {
        if (message != null && message.getId() != null && reportingDescriptor != null && reportingDescriptor.getMessageStrings() != null) {
            String messageText = reportingDescriptor.getMessageStrings().getAdditionalProperties().get(message.getId()).getText();
            List<String> arguments = message.getArguments();
            return Optional.of(SarifParserMessaging.renderString(messageText, arguments));
        }
        return Optional.empty();
    }

    private static String renderString(String text, List<String> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            text = text.replace("{" + i + "}", arguments.get(i));
        }
        return text;
    }

    private static Optional<String> findMarkdownOrText(MultiformatMessageString ... from) {
        for (MultiformatMessageString candidate : from) {
            if (candidate == null) continue;
            if (!Utils.isNullOrEmpty(candidate.getMarkdown())) {
                return Optional.ofNullable(candidate.getMarkdown());
            }
            if (Utils.isNullOrEmpty(candidate.getText())) continue;
            return Optional.ofNullable(candidate.getText());
        }
        return Optional.empty();
    }
}

