/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private static final Map<String, Character> XML_ESCAPE_CHARACTER_MAP;
    private static final String[] XML_ESCAPE_CHARACTERS;
    private static final char XML_ESCAPE_START = '&';

    private StringUtils() {
    }

    public static String htmlDecode(String input) {
        Pattern p = Pattern.compile("&#(\\d+);");
        Matcher m = p.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            Integer found = Integer.valueOf(m.group(1));
            String character = String.valueOf((char)found.intValue());
            m.appendReplacement(sb, character);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String xmlDecode(String input) {
        StringBuilder result = new StringBuilder(input.length());
        int i = 0;
        while (i < input.length()) {
            char current = input.charAt(i);
            boolean isValidXmlEscape = false;
            if (current == '&') {
                for (String escapeCharacter : XML_ESCAPE_CHARACTERS) {
                    if (!input.startsWith(escapeCharacter, i)) continue;
                    result.append(XML_ESCAPE_CHARACTER_MAP.get(escapeCharacter));
                    i += escapeCharacter.length();
                    isValidXmlEscape = true;
                    break;
                }
            }
            if (isValidXmlEscape) continue;
            result.append(current);
            ++i;
        }
        return result.toString();
    }

    public static String escapeHTML(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f' || c == '\"' || c == '<' || c == '>' || c == '&') {
                out.append("&#");
                out.append((int)c);
                out.append(';');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    @SuppressFBWarnings
    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    static {
        ConcurrentHashMap<String, Character> temp = new ConcurrentHashMap<String, Character>();
        temp.put("&apos;", Character.valueOf('\''));
        temp.put("&quot;", Character.valueOf('\"'));
        temp.put("&amp;", Character.valueOf('&'));
        temp.put("&lt;", Character.valueOf('<'));
        temp.put("&gt;", Character.valueOf('>'));
        XML_ESCAPE_CHARACTER_MAP = Collections.unmodifiableMap(temp);
        XML_ESCAPE_CHARACTERS = temp.keySet().toArray(new String[0]);
    }
}

