/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable;

import java.util.Collection;
import java.util.LinkedList;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AT_Context;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AT_Renderer;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AT_Row;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AsciiTableException;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.document.IsTable;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.document.TableRowStyle;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.document.TableRowType;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.strategies.collections.list.ArrayListStrategy;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.ClusterElementTransformer;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.StrBuilder_To_String;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.TextAlignment;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.translators.CharacterTranslator;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.translators.HtmlElementTranslator;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.translators.TargetTranslator;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;

public class AsciiTable
implements IsTable {
    protected AT_Context ctx;
    protected AT_Renderer renderer = AT_Renderer.create();
    protected final LinkedList<AT_Row> rows = new LinkedList();
    protected int colNumber;

    public AsciiTable() {
        this(null);
    }

    public AsciiTable(AT_Context ctx) {
        this.ctx = ctx != null ? ctx : new AT_Context();
    }

    public final AT_Row addRow(Collection<?> columns) throws NullPointerException, AsciiTableException {
        Validate.notNull(columns);
        return this.addRow(columns.toArray());
    }

    public final AT_Row addRow(Object ... columns) throws NullPointerException, AsciiTableException {
        AT_Row ret = AT_Row.createContentRow(columns, TableRowStyle.NORMAL);
        if (this.colNumber == 0) {
            this.colNumber = columns.length;
        } else if (columns.length != this.colNumber) {
            throw new AsciiTableException("wrong columns argument", "wrong number of columns, expected " + this.colNumber + " received " + columns.length);
        }
        this.rows.add(ret);
        return ret;
    }

    public final void addRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.NORMAL));
    }

    public final void addRule(TableRowStyle style) {
        Validate.notNull(style);
        Validate.validState(style != TableRowStyle.UNKNOWN, "cannot add a rule of unknown style", new Object[0]);
        this.rows.add(AT_Row.createRule(TableRowType.RULE, style));
    }

    public final void addStrongRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.STRONG));
    }

    public final void addHeavyRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.HEAVY));
    }

    public final void addLightRule() {
        this.rows.add(AT_Row.createRule(TableRowType.RULE, TableRowStyle.LIGHT));
    }

    public int getColNumber() {
        return this.colNumber;
    }

    @Override
    public AT_Context getContext() {
        return this.ctx;
    }

    @Override
    public LinkedList<AT_Row> getRawContent() {
        return this.rows;
    }

    @Override
    public AT_Renderer getRenderer() {
        return this.renderer;
    }

    @Override
    public String render() {
        return this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx);
    }

    @Override
    public String render(int width) {
        return this.renderer.render((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx, width);
    }

    @Override
    public Collection<String> renderAsCollection() {
        return ClusterElementTransformer.create().transform(this.renderer.renderAsCollection((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx), StrBuilder_To_String.create(), ArrayListStrategy.create());
    }

    @Override
    public Collection<String> renderAsCollection(int width) {
        return ClusterElementTransformer.create().transform(this.renderer.renderAsCollection((LinkedList<AT_Row>)this.getRawContent(), this.getColNumber(), this.ctx, this.ctx.getTextWidth(width)), StrBuilder_To_String.create(), ArrayListStrategy.create());
    }

    public AsciiTable setRenderer(AT_Renderer renderer) {
        if (renderer != null) {
            this.renderer = renderer;
        }
        return this;
    }

    @Override
    public StrBuilder toLog() {
        StrBuilder ret = new StrBuilder();
        ret.append("AsciiTable: ").append("#rows=").append(this.rows.size()).append(", #columns=").append(this.getColNumber()).append(", w=").append(this.ctx.getWidth()).append(", tw=").append(this.ctx.getTextWidth()).appendNewLine();
        return ret;
    }

    public AsciiTable setPadding(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPadding(padding);
        }
        return this;
    }

    public AsciiTable setPaddingBottom(int paddingBottom) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingBottom(paddingBottom);
        }
        return this;
    }

    public AsciiTable setPaddingBottomChar(Character paddingBottomChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingBottomChar(paddingBottomChar);
        }
        return this;
    }

    public AsciiTable setPaddingLeft(int paddingLeft) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeft(paddingLeft);
        }
        return this;
    }

    public AsciiTable setPaddingLeftChar(Character paddingLeftChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftChar(paddingLeftChar);
        }
        return this;
    }

    public AsciiTable setPaddingLeftRight(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftRight(padding);
        }
        return this;
    }

    public AsciiTable setPaddingLeftRight(int paddingLeft, int paddingRight) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingLeftRight(paddingLeft, paddingRight);
        }
        return this;
    }

    public AsciiTable setPaddingRight(int paddingRight) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingRight(paddingRight);
        }
        return this;
    }

    public AsciiTable setPaddingRightChar(Character paddingRightChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingRightChar(paddingRightChar);
        }
        return this;
    }

    public AsciiTable setPaddingTop(int paddingTop) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTop(paddingTop);
        }
        return this;
    }

    public AsciiTable setPaddingTopBottom(int padding) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopBottom(padding);
        }
        return this;
    }

    public AsciiTable setPaddingTopBottom(int paddingTop, int paddingBottom) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopBottom(paddingTop, paddingBottom);
        }
        return this;
    }

    public AsciiTable setPaddingTopChar(Character paddingTopChar) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setPaddingTopChar(paddingTopChar);
        }
        return this;
    }

    public AsciiTable setTextAlignment(TextAlignment textAlignment) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setTextAlignment(textAlignment);
        }
        return this;
    }

    public AsciiTable setTargetTranslator(TargetTranslator targetTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setTargetTranslator(targetTranslator);
        }
        return this;
    }

    public AsciiTable setHtmlElementTranslator(HtmlElementTranslator htmlElementTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setHtmlElementTranslator(htmlElementTranslator);
        }
        return this;
    }

    public AsciiTable setCharTranslator(CharacterTranslator charTranslator) {
        for (AT_Row row : this.rows) {
            if (row.getType() != TableRowType.CONTENT) continue;
            row.setCharTranslator(charTranslator);
        }
        return this;
    }
}

