/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable;

import java.util.LinkedList;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AT_ColumnWidthCalculator;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.AT_Row;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciitable.CWC_LongestWord;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;

public class CWC_LongestWordMax
implements AT_ColumnWidthCalculator {
    protected int max;
    protected int[] maxAr;

    public CWC_LongestWordMax(int max) {
        Validate.validState(max >= 3, "maximum column width cannot be smaller than 3", new Object[0]);
        this.max = max;
    }

    public CWC_LongestWordMax(int[] maxAr) {
        Validate.notNull(maxAr);
        for (int m : maxAr) {
            if (m == -1 || m >= 3) continue;
            throw new IllegalArgumentException("array contains maximum column width smaller than 3");
        }
        this.maxAr = maxAr;
    }

    @Override
    public int[] calculateColumnWidths(LinkedList<AT_Row> rows, int colNumbers, int tableWidth) {
        Validate.notNull(rows);
        if (this.maxAr != null && this.maxAr.length != colNumbers) {
            throw new IllegalArgumentException("maxAr length is not the same as rows in the table");
        }
        int[] ret = CWC_LongestWord.longestWord(rows, colNumbers);
        for (int i = 0; i < ret.length; ++i) {
            if (this.max != 0) {
                if (ret[i] <= this.max) continue;
                ret[i] = this.max;
                continue;
            }
            if (this.maxAr == null || this.maxAr[i] == -1 || ret[i] <= this.maxAr[i]) continue;
            ret[i] = this.maxAr[i];
        }
        return ret;
    }
}

