/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.asciithemes;

import se.bjurr.violations.violationsgitlib.de.vandermeer.asciithemes.TA_List;
import se.bjurr.violations.violationsgitlib.de.vandermeer.asciithemes.TA_Numbering;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;

public interface TA_EnumerateList
extends TA_List {
    public String getLabel(int var1);

    default public String getLabel(int[] levels, String separator, boolean useSepOnLast) {
        Validate.notNull(levels);
        if (this.getMaxLevel() == -1) {
            StrBuilder ret = new StrBuilder();
            for (int l : levels) {
                ret.appendSeparator(separator);
                ret.append(this.getLabel(l));
            }
            if (useSepOnLast) {
                ret.append(separator);
            }
            return ret.toString();
        }
        return null;
    }

    public int getMaxLevel();

    @Override
    default public StrBuilder toDoc() {
        if (this.getMaxLevel() == 0) {
            throw new IllegalArgumentException("enumerate list toDoc: max level is 0");
        }
        if (this.getMaxLevel() < -1) {
            throw new IllegalArgumentException("enumerate list toDoc: max level is < -1");
        }
        StrBuilder ret = new StrBuilder(30);
        ret.append(this.getLabel(1)).append(" item 1").appendNewLine();
        ret.append(this.getLabel(1)).append(" item 2");
        int n = 2;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(2)).append(" item 2");
        }
        n = 3;
        if (this.getMaxLevel() == -1 || this.getMaxLevel() >= n) {
            ret.appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3)).append(" item 1").appendNewLine();
            ret.appendPadding(2 * (n - 1), ' ').append(this.getLabel(3)).append(" item 2").appendNewLine();
        }
        ret.appendNewLine();
        ret.append(this.getLabel(new int[]{1}, ".", true)).append(" item 1").appendNewLine();
        ret.append(this.getLabel(new int[]{1, 2}, ".", true)).append(" item 1/2").appendNewLine();
        ret.append(this.getLabel(new int[]{1, 2, 3}, ".", true)).append(" item 1/2/3").appendNewLine();
        ret.append(this.getLabel(new int[]{1, 2, 3, 4}, ".", true)).append(" item 1/2/3/4").appendNewLine();
        ret.append(this.getLabel(new int[]{1, 2, 3, 4, 5}, ".", true)).append(" item 1/2/3/4/5");
        return ret;
    }

    public static TA_EnumerateList create(final TA_Numbering numbering, final String description) {
        Validate.notNull(numbering);
        Validate.notBlank(description);
        return new TA_EnumerateList(){

            @Override
            public int getMaxLevel() {
                return -1;
            }

            @Override
            public String getLabel(int level) {
                return numbering.getNumber(level);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static TA_EnumerateList create(final String description, final TA_Numbering ... numbering) {
        Validate.notNull(numbering);
        Validate.noNullElements(numbering);
        Validate.notBlank(description);
        return new TA_EnumerateList(){

            @Override
            public int getMaxLevel() {
                return numbering.length;
            }

            @Override
            public String getLabel(int level) {
                return numbering[0].getNumber(level);
            }

            @Override
            public String getLabel(int[] levels, String separator, boolean useSepOnLast) {
                String simple = TA_EnumerateList.super.getLabel(levels, separator, useSepOnLast);
                if (simple != null) {
                    return simple;
                }
                Validate.notNull(levels);
                Validate.validState(numbering.length >= levels.length, "the required levels are going deeper than the provided numbering: levels <" + levels.length + "> provided <" + numbering.length + ">", new Object[0]);
                StrBuilder ret = new StrBuilder();
                for (int i = 0; i < levels.length; ++i) {
                    ret.appendSeparator(separator);
                    ret.append(numbering[i].getNumber(levels[i]));
                }
                if (useSepOnLast) {
                    ret.append(separator);
                }
                return ret.toString();
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }
}

