/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.FormattingTupleWrapper;

public final class MessageConsole {
    public static boolean PRINT_MESSAGES = true;
    public static boolean PRINT_ERROR_MESSAGES = true & PRINT_MESSAGES;
    public static boolean PRINT_WARNING_MESSAGES = true & PRINT_MESSAGES;
    public static boolean PRINT_INFO_MESSAGES = true & PRINT_MESSAGES;
    public static boolean PRINT_TRACE_MESSAGES = true & PRINT_MESSAGES;
    public static boolean PRINT_DEBUG_MESSAGES = true & PRINT_MESSAGES;

    public static void conInfo(String msg) {
        if (PRINT_INFO_MESSAGES) {
            System.out.println(msg);
        }
    }

    public static void conInfo(String msg, Object ... args) {
        if (PRINT_INFO_MESSAGES) {
            System.out.println(FormattingTupleWrapper.create(msg, args).getMessage());
        }
    }

    public static void conWarn(String msg) {
        if (PRINT_WARNING_MESSAGES) {
            System.out.println(msg);
        }
    }

    public static void conWarn(String msg, Object ... args) {
        if (PRINT_WARNING_MESSAGES) {
            System.out.println(FormattingTupleWrapper.create(msg, args).getMessage());
        }
    }

    public static void conError(String msg) {
        if (PRINT_ERROR_MESSAGES) {
            System.err.println(msg);
        }
    }

    public static void conError(String msg, Object ... args) {
        if (PRINT_ERROR_MESSAGES) {
            System.err.println(FormattingTupleWrapper.create(msg, args).getMessage());
        }
    }

    public static void conTrace(String msg) {
        if (PRINT_TRACE_MESSAGES) {
            System.out.println(msg);
        }
    }

    public static void conTrace(String msg, Object ... args) {
        if (PRINT_TRACE_MESSAGES) {
            System.out.println(FormattingTupleWrapper.create(msg, args).getMessage());
        }
    }

    public static void conDebug(String msg) {
        if (PRINT_DEBUG_MESSAGES) {
            System.out.println(msg);
        }
    }

    public static void conDebug(String msg, Object ... args) {
        if (PRINT_DEBUG_MESSAGES) {
            System.out.println(FormattingTupleWrapper.create(msg, args).getMessage());
        }
    }

    public static String getDefaultEncoding() {
        byte[] byteArray = new byte[]{97};
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        InputStreamReader reader = new InputStreamReader(inputStream);
        return reader.getEncoding();
    }

    public static BufferedReader getStdIn(String appName) {
        BufferedReader ret = null;
        try {
            ret = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            MessageConsole.conError("{}: encoding exception opening SdtIn, expecting UTF-8 -> {}", appName, ex.getMessage());
        }
        return ret;
    }

    public MessageConsole() {
        throw new UnsupportedOperationException(MessageConsole.class.getSimpleName() + " cannot be instantiated");
    }
}

