/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.antlr;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.antlr.IsST;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.categories.CategoryIs;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.StringUtils;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.STGroup;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.STGroupDir;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.STGroupFile;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.STGroupString;

public interface IsSTGroup
extends CategoryIs {
    public STGroup getSTGroup();

    default public String getGroupName() {
        STGroup stg = this.getSTGroup();
        String ret = null;
        if (stg instanceof STGroupFile) {
            ret = ((STGroupFile)stg).fileName;
        } else if (stg instanceof STGroupString) {
            ret = ((STGroupString)stg).sourceName;
        } else if (stg instanceof STGroupDir) {
            ret = ((STGroupDir)stg).groupDirName;
        }
        return ret == null ? ret : StringUtils.substringBeforeLast(ret, ".");
    }

    public Map<String, Set<String>> getExpectedChunks();

    default public Set<String> validate() {
        if (this.getExpectedChunks() == null) {
            return null;
        }
        if (this.getSTGroup() == null) {
            return null;
        }
        STGroup stg = this.getSTGroup();
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.getExpectedChunks().entrySet()) {
            if (entry.getKey() == null || "".equals(entry.getKey())) continue;
            if (stg.isDefined(entry.getKey())) {
                IsST isst = IsST.create(stg.getInstanceOf(entry.getKey()), entry.getValue());
                for (String s : isst.validate()) {
                    ret.add("STGroup <" + this.getGroupName() + ">: " + s);
                }
                continue;
            }
            ret.add("STGroup <" + this.getGroupName() + "> does not define expected template <" + entry.getKey() + ">");
        }
        return ret;
    }
}

