/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.messagesets;

import java.util.LinkedHashSet;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.messagesets.IsErrorSet;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.FormattingTuple;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.MessageFormatter;

public interface IsErrorSetFT
extends IsErrorSet<FormattingTuple> {
    default public void addAllErrors(IsErrorSetFT errors) {
        this.getErrorMessages().addAll(errors.getErrorMessages());
    }

    @Override
    default public void addError(String error) {
        Validate.notBlank(error);
        this.addError(MessageFormatter.arrayFormat(error, new Object[0]));
    }

    default public void addError(String error, Object ... obj) {
        Validate.notBlank(error);
        Validate.notNull(obj);
        Validate.noNullElements(obj);
        this.addError(MessageFormatter.arrayFormat(error, obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getErrorMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsErrorSetFT create() {
        return new IsErrorSetFT(){
            final Set<FormattingTuple> errorSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getErrorMessages() {
                return this.errorSet;
            }
        };
    }
}

