/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.messagesets;

import java.util.LinkedHashSet;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.messagesets.IsInfoSet;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.FormattingTuple;
import se.bjurr.violations.violationsgitlib.org.slf4j.helpers.MessageFormatter;

public interface IsInfoSetFT
extends IsInfoSet<FormattingTuple> {
    default public void addAllInfos(IsInfoSetFT infos) {
        this.getInfoMessages().addAll(infos.getInfoMessages());
    }

    @Override
    default public void addInfo(String info) {
        Validate.notBlank(info);
        this.addInfo(MessageFormatter.arrayFormat(info, new Object[0]));
    }

    default public void addInfo(String info, Object ... obj) {
        Validate.notBlank(info);
        Validate.notNull(obj);
        Validate.noNullElements(obj);
        this.addInfo(MessageFormatter.arrayFormat(info, obj));
    }

    @Override
    default public String render() {
        StrBuilder ret = new StrBuilder(100);
        for (FormattingTuple ft : this.getInfoMessages()) {
            ret.append(ft.getMessage()).appendNewLine();
        }
        return ret.toString();
    }

    public static IsInfoSetFT create() {
        return new IsInfoSetFT(){
            final Set<FormattingTuple> infoSet = new LinkedHashSet<FormattingTuple>();

            @Override
            public Set<FormattingTuple> getInfoMessages() {
                return this.infoSet;
            }
        };
    }
}

