/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat;

import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.IsTransformer;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.StringUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;

public interface String_To_Justified
extends IsTransformer<String, StrBuilder> {
    public static final int DEFAULT_LENGTH = 80;
    public static final char DEFAULT_INNER_WHITESPACE_CHARACTER = ' ';

    default public int getLength() {
        return 80;
    }

    default public Character getInnerWsChar() {
        return Character.valueOf(' ');
    }

    default public StrBuilder getBuilderForAppend() {
        return null;
    }

    @Override
    default public StrBuilder transform(String s) {
        IsTransformer.super.transform(s);
        StrBuilder ret = this.getBuilderForAppend() == null ? new StrBuilder(this.getLength()) : this.getBuilderForAppend();
        String[] ar = StringUtils.split(s == null ? "" : s);
        int length = 0;
        for (String str : ar) {
            length += str.length();
        }
        int l = ar.length - 1 == 0 ? 1 : ar.length - 1;
        int first = (this.getLength() - length) / l * (ar.length - 1);
        while (first > 0) {
            for (int i = 0; i < ar.length - 1; ++i) {
                if (first == 0) continue;
                int n = i;
                ar[n] = ar[n] + this.getInnerWsChar();
                --first;
            }
        }
        int second = (this.getLength() - length) % l;
        while (second > 0) {
            for (int i = ar.length - 2; i > 0; --i) {
                if (second == 0) continue;
                int n = i;
                ar[n] = ar[n] + this.getInnerWsChar();
                --second;
            }
        }
        ret.append(StringUtils.join(ar));
        while (ret.length() < this.getLength()) {
            ret.append(' ');
        }
        return ret;
    }

    public static String_To_Justified create(final int length, final Character innerWsChar, final StrBuilder builder) {
        Validate.validState(length > 0, "cannot work with lenght of less than 1", new Object[0]);
        return new String_To_Justified(){

            @Override
            public int getLength() {
                return length < 1 ? String_To_Justified.super.getLength() : length;
            }

            @Override
            public StrBuilder getBuilderForAppend() {
                return builder;
            }

            @Override
            public Character getInnerWsChar() {
                return innerWsChar == null ? String_To_Justified.super.getInnerWsChar() : innerWsChar;
            }
        };
    }

    public static StrBuilder convert(String s, int length) {
        return String_To_Justified.create(length, null, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character innerWsChar) {
        return String_To_Justified.create(length, innerWsChar, null).transform(s);
    }

    public static StrBuilder convert(String s, int length, StrBuilder builder) {
        return String_To_Justified.create(length, null, builder).transform(s);
    }

    public static StrBuilder convert(String s, int length, Character innerWsChar, StrBuilder builder) {
        return String_To_Justified.create(length, innerWsChar, builder).transform(s);
    }
}

