/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat;

import java.util.ArrayList;
import java.util.Collection;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.strategies.IsCollectionStrategy;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.strategies.collections.list.ArrayListStrategy;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.ClusterElementTransformer;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.IsTransformer;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.String_To_Centered;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.String_To_Justified;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.String_To_LeftPadded;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.String_To_NoWs;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.String_To_RightPadded;
import se.bjurr.violations.violationsgitlib.de.vandermeer.skb.interfaces.transformers.textformat.Text_To_WrappedFormat;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.ArrayUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.StringUtils;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.Validate;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.text.StrBuilder;
import se.bjurr.violations.violationsgitlib.org.apache.commons.lang3.tuple.Pair;

public interface Text_To_FormattedText
extends IsTransformer<String, Collection<StrBuilder>> {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_JUSTIFIED = 4;
    public static final int ALIGN_JUSTIFIED_LEFT = 5;
    public static final int ALIGN_JUSTIFIED_RIGHT = 6;
    public static final int FORMAT_NONE = 100;
    public static final int FORMAT_FIRST_LINE = 101;
    public static final int FORMAT_HANGING_PARAGRAPH = 102;
    public static final int FORMAT_FIRSTLINE_AND_HANGINGPARAGRAPH = 103;
    public static final int FORMAT_DROPCAP = 120;
    public static final int FORMAT_DROPCAP_WITH_PADDING = 121;
    public static final int DEFAULT_TEXT_WIDTH = 80;
    public static final char DEFAULT_LEFT_PADDING_CHARACTER = ' ';
    public static final char DEFAULT_RIGHT_PADDING_CHARACTER = ' ';
    public static final char DEFAULT_INNER_WHITESPACE_CHARACTER = ' ';
    public static final int DEFAULT_HANGING_INDENTATION = 4;
    public static final int DEFAULT_FIRSTLINE_INDENTATION = 4;
    public static final int DEFAULT_CHARS_BETWEEN_DROPCAP_AND_TEXT = 3;
    public static final int DEFAULT_LINES_AFTER_DROPCAP = 1;
    public static final IsCollectionStrategy<?, StrBuilder> DEFAULT_COLLECTION_STRATEGY = ArrayListStrategy.create();

    default public int getAlignment() {
        return 5;
    }

    default public int getFormat() {
        return 100;
    }

    default public Character getInnerWsChar() {
        return Character.valueOf(' ');
    }

    default public Character getLeftPaddingChar() {
        return Character.valueOf(' ');
    }

    default public Character getRightPaddingChar() {
        return Character.valueOf(' ');
    }

    default public int getTextWidth() {
        return 80;
    }

    default public IsCollectionStrategy<?, StrBuilder> getCollectionStrategy() {
        return DEFAULT_COLLECTION_STRATEGY;
    }

    default public int getHangingIndentation() {
        return 4;
    }

    default public int getFirstlineIndentation() {
        return 4;
    }

    default public int getCharsBetweenDroppcapAndText() {
        return 3;
    }

    default public int getLinesAfterDropcap() {
        return 1;
    }

    @Override
    default public Collection<StrBuilder> transform(StrBuilder sb) {
        Validate.notNull(sb);
        return this.transform(sb.toString());
    }

    public String[] getDropCap();

    @Override
    default public Collection<StrBuilder> transform(String s) {
        IsTransformer.super.transform(s);
        Validate.validState(ArrayUtils.contains(new int[]{1, 3, 2, 4, 5, 6}, this.getAlignment()), "unknown alignment <" + this.getAlignment() + ">", new Object[0]);
        Validate.validState(ArrayUtils.contains(new int[]{100, 102, 101, 103, 120, 121}, this.getFormat()), "unknown format <" + this.getFormat() + ">", new Object[0]);
        Validate.validState(this.getTextWidth() > 0, "text width is less than 1, was <" + this.getTextWidth() + ">", new Object[0]);
        Validate.notNull(this.getInnerWsChar());
        Validate.notNull(this.getLeftPaddingChar());
        Validate.notNull(this.getRightPaddingChar());
        Validate.notNull(this.getCollectionStrategy());
        Validate.validState(this.getHangingIndentation() > 0, "hanging paragraph indentation was less than null, setting was <" + this.getHangingIndentation() + ">", new Object[0]);
        Validate.validState(this.getFirstlineIndentation() > 0, "first line indentation was less than null, setting was <" + this.getFirstlineIndentation() + ">", new Object[0]);
        Validate.validState(this.getCharsBetweenDroppcapAndText() > 0, "characters between dropped capital letter and text lines was less than 1, setting was <" + this.getCharsBetweenDroppcapAndText() + ">", new Object[0]);
        Validate.validState(this.getLinesAfterDropcap() > 0, "lines added after a dropped capital letter was less than 1, setting was <" + this.getLinesAfterDropcap() + ">", new Object[0]);
        Object ret = this.getCollectionStrategy().get();
        if (StringUtils.isBlank(s)) {
            ret.add((StrBuilder)new StrBuilder().appendPadding(this.getTextWidth(), ' '));
            return ret;
        }
        if (this.getFormat() == 120 || this.getFormat() == 121) {
            Validate.notNull(this.getDropCap());
            Validate.noNullElements(this.getDropCap());
            int l = 0;
            for (String ds : this.getDropCap()) {
                if (l != 0) {
                    Validate.validState(l == ds.length(), "dropped capital letter has some variations in length in the array, not alowed", new Object[0]);
                }
                l = ds.length();
            }
        }
        String text = String_To_NoWs.convert(s);
        Pair<ArrayList<String>, ArrayList<String>> pair = null;
        int topWidth = 0;
        int bottomWidth = 0;
        switch (this.getFormat()) {
            case 100: {
                topWidth = bottomWidth = this.getTextWidth();
                pair = Text_To_WrappedFormat.convert(text, topWidth);
                Validate.isTrue(pair.getLeft().size() == 0);
                break;
            }
            case 102: {
                topWidth = this.getTextWidth();
                bottomWidth = this.getTextWidth() - this.getHangingIndentation();
                pair = Text_To_WrappedFormat.convert(text, bottomWidth, Pair.of(1, topWidth));
                Validate.isTrue(pair.getLeft().size() == 1);
                break;
            }
            case 101: {
                topWidth = this.getTextWidth() - this.getFirstlineIndentation();
                bottomWidth = this.getTextWidth();
                pair = Text_To_WrappedFormat.convert(text, bottomWidth, Pair.of(1, topWidth));
                Validate.isTrue(pair.getLeft().size() == 1);
                break;
            }
            case 103: {
                topWidth = this.getTextWidth() - this.getFirstlineIndentation();
                bottomWidth = this.getTextWidth() - this.getHangingIndentation();
                pair = Text_To_WrappedFormat.convert(text, bottomWidth, Pair.of(1, topWidth));
                Validate.isTrue(pair.getLeft().size() == 1);
                break;
            }
            case 120: {
                topWidth = this.getTextWidth() - this.getDropCap()[0].length() - 1;
                bottomWidth = this.getTextWidth();
                pair = Text_To_WrappedFormat.convert(text.substring(1), bottomWidth, Pair.of(this.getDropCap().length + this.getLinesAfterDropcap(), topWidth));
                Validate.isTrue(pair.getLeft().size() == this.getDropCap().length + 1);
                break;
            }
            case 121: {
                topWidth = this.getTextWidth() - this.getDropCap()[0].length() - this.getCharsBetweenDroppcapAndText();
                bottomWidth = this.getTextWidth();
                pair = Text_To_WrappedFormat.convert(text.substring(1), bottomWidth, Pair.of(this.getDropCap().length + this.getLinesAfterDropcap(), topWidth));
                Validate.isTrue(pair.getLeft().size() == this.getDropCap().length + 1);
            }
        }
        IsTransformer<String, StrBuilder> topTr = null;
        IsTransformer<String, StrBuilder> bottomTr = null;
        switch (this.getAlignment()) {
            case 1: {
                topTr = String_To_LeftPadded.create(topWidth, this.getRightPaddingChar(), this.getInnerWsChar(), null);
                bottomTr = String_To_LeftPadded.create(bottomWidth, this.getRightPaddingChar(), this.getInnerWsChar(), null);
                break;
            }
            case 3: {
                topTr = String_To_RightPadded.create(topWidth, this.getLeftPaddingChar(), this.getInnerWsChar(), null);
                bottomTr = String_To_RightPadded.create(bottomWidth, this.getLeftPaddingChar(), this.getInnerWsChar(), null);
                break;
            }
            case 2: {
                topTr = String_To_Centered.create(topWidth, this.getLeftPaddingChar(), this.getRightPaddingChar(), this.getInnerWsChar(), null);
                bottomTr = String_To_Centered.create(bottomWidth, this.getLeftPaddingChar(), this.getRightPaddingChar(), this.getInnerWsChar(), null);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                topTr = String_To_Justified.create(topWidth, this.getInnerWsChar(), null);
                bottomTr = String_To_Justified.create(bottomWidth, this.getInnerWsChar(), null);
            }
        }
        Object top = ClusterElementTransformer.create().transform((Iterable)pair.getLeft(), topTr, this.getCollectionStrategy());
        Object bottom = ClusterElementTransformer.create().transform((Iterable)pair.getRight(), bottomTr, this.getCollectionStrategy());
        if (bottom.size() > 0 && (this.getAlignment() == 5 || this.getAlignment() == 6)) {
            Object[] objAr = bottom.toArray();
            Object line = objAr[objAr.length - 1];
            bottom.remove(objAr[objAr.length - 1]);
            String lineString = line.toString().replaceAll(this.getInnerWsChar().toString(), " ").replaceAll("\\h+", " ");
            if (this.getAlignment() == 5) {
                bottom.add((StrBuilder)String_To_LeftPadded.convert(lineString, bottomWidth, this.getRightPaddingChar()));
            }
            if (this.getAlignment() == 6) {
                bottom.add((StrBuilder)String_To_RightPadded.convert(lineString, bottomWidth, this.getLeftPaddingChar()));
            }
        }
        switch (this.getFormat()) {
            case 100: {
                ret.addAll(top);
                ret.addAll(bottom);
                break;
            }
            case 102: {
                ret.addAll(top);
                for (StrBuilder b : bottom) {
                    ret.add((StrBuilder)new StrBuilder().appendPadding(this.getHangingIndentation(), this.getLeftPaddingChar().charValue()).append(b));
                }
                break;
            }
            case 101: {
                for (StrBuilder t : top) {
                    ret.add((StrBuilder)new StrBuilder().appendPadding(this.getFirstlineIndentation(), this.getLeftPaddingChar().charValue()).append(t));
                }
                ret.addAll(bottom);
                break;
            }
            case 103: {
                for (StrBuilder t : top) {
                    ret.add((StrBuilder)new StrBuilder().appendPadding(this.getFirstlineIndentation(), this.getLeftPaddingChar().charValue()).append(t));
                }
                for (StrBuilder b : bottom) {
                    ret.add((StrBuilder)new StrBuilder().appendPadding(this.getHangingIndentation(), this.getLeftPaddingChar().charValue()).append(b));
                }
                break;
            }
            case 120: {
                int count = 0;
                for (StrBuilder t : top) {
                    if (count < this.getDropCap().length) {
                        ret.add((StrBuilder)new StrBuilder().append(this.getDropCap()[count]).append(' ').append(t));
                    } else {
                        ret.add((StrBuilder)new StrBuilder().appendPadding(this.getDropCap()[0].length(), ' ').append(' ').append(t));
                    }
                    ++count;
                }
                ret.addAll(bottom);
                break;
            }
            case 121: {
                int count = 0;
                for (StrBuilder t : top) {
                    if (count < this.getDropCap().length) {
                        ret.add((StrBuilder)new StrBuilder().append(this.getDropCap()[count]).appendPadding(this.getCharsBetweenDroppcapAndText(), ' ').append(t));
                    } else {
                        ret.add((StrBuilder)new StrBuilder().appendPadding(this.getDropCap()[0].length(), ' ').appendPadding(this.getCharsBetweenDroppcapAndText(), ' ').append(t));
                    }
                    ++count;
                }
                ret.addAll(bottom);
            }
        }
        return ret;
    }

    public static Text_To_FormattedText create(final int textWidth, final int alignment, final int format, final Character leftPadding, final Character rightPadding, final Character innerWS, final int hangingIndentation, final int firstlineIndentation, final String[] dropCap, final int charsBetweenDroppcapAndText, final int linesAfterDropcap, final IsCollectionStrategy<?, StrBuilder> strategy) {
        return new Text_To_FormattedText(){

            @Override
            public int getAlignment() {
                return alignment;
            }

            @Override
            public int getFormat() {
                return format;
            }

            @Override
            public int getTextWidth() {
                return textWidth;
            }

            @Override
            public Character getInnerWsChar() {
                return innerWS == null ? Text_To_FormattedText.super.getInnerWsChar() : innerWS;
            }

            @Override
            public Character getLeftPaddingChar() {
                return leftPadding == null ? Text_To_FormattedText.super.getLeftPaddingChar() : leftPadding;
            }

            @Override
            public Character getRightPaddingChar() {
                return rightPadding == null ? Text_To_FormattedText.super.getRightPaddingChar() : rightPadding;
            }

            @Override
            public IsCollectionStrategy<?, StrBuilder> getCollectionStrategy() {
                return strategy == null ? Text_To_FormattedText.super.getCollectionStrategy() : strategy;
            }

            @Override
            public int getHangingIndentation() {
                return hangingIndentation < 1 ? Text_To_FormattedText.super.getHangingIndentation() : hangingIndentation;
            }

            @Override
            public int getFirstlineIndentation() {
                return firstlineIndentation < 1 ? Text_To_FormattedText.super.getFirstlineIndentation() : firstlineIndentation;
            }

            @Override
            public int getCharsBetweenDroppcapAndText() {
                return charsBetweenDroppcapAndText < 1 ? Text_To_FormattedText.super.getCharsBetweenDroppcapAndText() : charsBetweenDroppcapAndText;
            }

            @Override
            public int getLinesAfterDropcap() {
                return linesAfterDropcap < 1 ? Text_To_FormattedText.super.getLinesAfterDropcap() : linesAfterDropcap;
            }

            @Override
            public String[] getDropCap() {
                return dropCap;
            }
        };
    }

    public static Collection<StrBuilder> left(String text, int textWidth) {
        return Text_To_FormattedText.left(text, textWidth, 100, null, null, null);
    }

    public static Collection<StrBuilder> left(String text, int textWidth, int format) {
        return Text_To_FormattedText.left(text, textWidth, format, null, null, null);
    }

    public static Collection<StrBuilder> left(String text, int textWidth, int format, Character padding) {
        return Text_To_FormattedText.left(text, textWidth, format, padding, null, null);
    }

    public static Collection<StrBuilder> left(String text, int textWidth, int format, Character padding, Character innerWS) {
        return Text_To_FormattedText.left(text, textWidth, format, padding, innerWS, null);
    }

    public static Collection<StrBuilder> left(String text, int textWidth, int format, Character padding, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 1, format, null, padding, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }

    public static Collection<StrBuilder> center(String text, int textWidth) {
        return Text_To_FormattedText.center(text, textWidth, 100, null, null, null, null);
    }

    public static Collection<StrBuilder> center(String text, int textWidth, int format) {
        return Text_To_FormattedText.center(text, textWidth, format, null, null, null, null);
    }

    public static Collection<StrBuilder> center(String text, int textWidth, int format, Character padding) {
        return Text_To_FormattedText.center(text, textWidth, format, padding, padding, null, null);
    }

    public static Collection<StrBuilder> center(String text, int textWidth, int format, Character leftPadding, Character rightPadding) {
        return Text_To_FormattedText.center(text, textWidth, format, leftPadding, rightPadding, null, null);
    }

    public static Collection<StrBuilder> center(String text, int textWidth, int format, Character leftPadding, Character rightPadding, Character innerWS) {
        return Text_To_FormattedText.center(text, textWidth, format, leftPadding, rightPadding, innerWS, null);
    }

    public static Collection<StrBuilder> center(String text, int textWidth, int format, Character leftPadding, Character rightPadding, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 2, format, leftPadding, rightPadding, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }

    public static Collection<StrBuilder> right(String text, int textWidth) {
        return Text_To_FormattedText.right(text, textWidth, 100, null, null, null);
    }

    public static Collection<StrBuilder> right(String text, int textWidth, int format) {
        return Text_To_FormattedText.right(text, textWidth, format, null, null, null);
    }

    public static Collection<StrBuilder> right(String text, int textWidth, int format, Character padding) {
        return Text_To_FormattedText.right(text, textWidth, format, padding, null, null);
    }

    public static Collection<StrBuilder> right(String text, int textWidth, int format, Character padding, Character innerWS) {
        return Text_To_FormattedText.right(text, textWidth, format, padding, innerWS, null);
    }

    public static Collection<StrBuilder> right(String text, int textWidth, int format, Character padding, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 3, format, padding, null, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }

    public static Collection<StrBuilder> justified(String text, int textWidth) {
        return Text_To_FormattedText.justified(text, textWidth, 100, null, null);
    }

    public static Collection<StrBuilder> justified(String text, int textWidth, int format) {
        return Text_To_FormattedText.justified(text, textWidth, format, null, null);
    }

    public static Collection<StrBuilder> justified(String text, int textWidth, int format, Character innerWS) {
        return Text_To_FormattedText.justified(text, textWidth, format, innerWS, null);
    }

    public static Collection<StrBuilder> justified(String text, int textWidth, int format, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 4, format, null, null, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }

    public static Collection<StrBuilder> justifiedLeft(String text, int textWidth) {
        return Text_To_FormattedText.justifiedLeft(text, textWidth, 100, null, null, null);
    }

    public static Collection<StrBuilder> justifiedLeft(String text, int textWidth, int format) {
        return Text_To_FormattedText.justifiedLeft(text, textWidth, format, null, null, null);
    }

    public static Collection<StrBuilder> justifiedLeft(String text, int textWidth, int format, Character padding) {
        return Text_To_FormattedText.justifiedLeft(text, textWidth, format, padding, null, null);
    }

    public static Collection<StrBuilder> justifiedLeft(String text, int textWidth, int format, Character padding, Character innerWS) {
        return Text_To_FormattedText.justifiedLeft(text, textWidth, format, padding, innerWS, null);
    }

    public static Collection<StrBuilder> justifiedLeft(String text, int textWidth, int format, Character padding, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 5, format, null, padding, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }

    public static Collection<StrBuilder> justifiedRight(String text, int textWidth) {
        return Text_To_FormattedText.justifiedRight(text, textWidth, 100, null, null, null);
    }

    public static Collection<StrBuilder> justifiedRight(String text, int textWidth, int format) {
        return Text_To_FormattedText.justifiedRight(text, textWidth, format, null, null, null);
    }

    public static Collection<StrBuilder> justifiedRight(String text, int textWidth, int format, Character padding) {
        return Text_To_FormattedText.justifiedRight(text, textWidth, format, padding, null, null);
    }

    public static Collection<StrBuilder> justifiedRight(String text, int textWidth, int format, Character padding, Character innerWS) {
        return Text_To_FormattedText.justifiedRight(text, textWidth, format, padding, innerWS, null);
    }

    public static Collection<StrBuilder> justifiedRight(String text, int textWidth, int format, Character padding, Character innerWS, IsCollectionStrategy<?, StrBuilder> strategy) {
        return Text_To_FormattedText.create(textWidth, 6, format, padding, null, innerWS, 0, 0, null, 0, 0, strategy).transform(text);
    }
}

