/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.antlr.v4.codegen.target;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import se.bjurr.violations.violationsgitlib.org.antlr.v4.codegen.CodeGenerator;
import se.bjurr.violations.violationsgitlib.org.antlr.v4.codegen.Target;
import se.bjurr.violations.violationsgitlib.org.antlr.v4.tool.ast.GrammarAST;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.STGroup;
import se.bjurr.violations.violationsgitlib.org.stringtemplate.v4.StringRenderer;

public class JavaScriptTarget
extends Target {
    protected static final String[] javaScriptKeywords = new String[]{"break", "case", "class", "catch", "const", "continue", "se.bjurr.violations.violationsgitlib.debugger", "se.bjurr.violations.violationsgitlib.default", "se.bjurr.violations.violationsgitlib.delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield", "enum", "await", "implements", "package", "protected", "static", "interface", "private", "public", "abstract", "boolean", "byte", "char", "double", "final", "float", "goto", "int", "long", "native", "short", "synchronized", "transient", "volatile", "null", "true", "false"};
    protected final Set<String> badWords = new HashSet<String>();

    public JavaScriptTarget(CodeGenerator gen) {
        super(gen, "JavaScript");
    }

    @Override
    public String getVersion() {
        return "4.5.1";
    }

    public Set<String> getBadWords() {
        if (this.badWords.isEmpty()) {
            this.addBadWords();
        }
        return this.badWords;
    }

    protected void addBadWords() {
        this.badWords.addAll(Arrays.asList(javaScriptKeywords));
        this.badWords.add("rule");
        this.badWords.add("parserRule");
    }

    @Override
    public String getTargetStringLiteralFromANTLRStringLiteral(CodeGenerator generator, String literal, boolean addQuotes) {
        StringBuilder sb = new StringBuilder();
        String is = literal;
        if (addQuotes) {
            sb.append('\"');
        }
        for (int i = 1; i < is.length() - 1; ++i) {
            if (is.charAt(i) == '\\') {
                switch (is.charAt(i + 1)) {
                    case '\"': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        sb.append('\\');
                        break;
                    }
                    case 'u': {
                        sb.append('\\');
                        sb.append('\\');
                        break;
                    }
                }
                ++i;
            } else if (is.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(is.charAt(i));
        }
        if (addQuotes) {
            sb.append('\"');
        }
        return sb.toString();
    }

    @Override
    public String encodeIntAsCharEscape(int v) {
        if (v < 0 || v > 65535) {
            throw new IllegalArgumentException(String.format("Cannot encode the specified value: %d", v));
        }
        if (v >= 0 && v < this.targetCharValueEscape.length && this.targetCharValueEscape[v] != null) {
            return this.targetCharValueEscape[v];
        }
        if (v >= 32 && v < 127) {
            return String.valueOf((char)v);
        }
        String hex = Integer.toHexString(v | 0x10000).substring(1, 5);
        return "\\u" + hex;
    }

    @Override
    public int getSerializedATNSegmentLimit() {
        return 29;
    }

    @Override
    public int getInlineTestSetWordSize() {
        return 32;
    }

    @Override
    protected boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        return this.getBadWords().contains(idNode.getText());
    }

    @Override
    protected STGroup loadTemplates() {
        STGroup result = super.loadTemplates();
        result.registerRenderer(String.class, new JavaStringRenderer(), true);
        return result;
    }

    @Override
    public boolean wantsBaseListener() {
        return false;
    }

    @Override
    public boolean wantsBaseVisitor() {
        return false;
    }

    @Override
    public boolean supportsOverloadedMethods() {
        return false;
    }

    protected static class JavaStringRenderer
    extends StringRenderer {
        protected JavaStringRenderer() {
        }

        @Override
        public String toString(Object o, String formatString, Locale locale) {
            if ("java-escape".equals(formatString)) {
                return ((String)o).replace("\\u", "\\u005Cu");
            }
            return super.toString(o, formatString, locale);
        }
    }
}

