/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsGarbageCollector;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.FileRepository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.GC;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ProgressMonitor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.StoredConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.storage.pack.PackConfig;

public class GarbageCollectCommand
extends GitCommand<Properties> {
    public static final int DEFAULT_GC_AGGRESSIVE_DEPTH = 250;
    public static final int DEFAULT_GC_AGGRESSIVE_WINDOW = 250;
    private ProgressMonitor monitor;
    private Date expire;
    private PackConfig pconfig;
    private Boolean packKeptObjects;

    protected GarbageCollectCommand(Repository repo) {
        super(repo);
        this.pconfig = new PackConfig(repo);
    }

    public GarbageCollectCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public GarbageCollectCommand setExpire(Date expire) {
        this.expire = expire;
        return this;
    }

    public GarbageCollectCommand setAggressive(boolean aggressive) {
        if (aggressive) {
            StoredConfig repoConfig = this.repo.getConfig();
            this.pconfig.setDeltaSearchWindowSize(repoConfig.getInt("gc", "aggressiveWindow", 250));
            this.pconfig.setMaxDeltaDepth(repoConfig.getInt("gc", "aggressiveDepth", 250));
            this.pconfig.setReuseObjects(false);
        } else {
            this.pconfig = new PackConfig(this.repo);
        }
        return this;
    }

    public GarbageCollectCommand setPackKeptObjects(boolean packKeptObjects) {
        this.packKeptObjects = packKeptObjects;
        return this;
    }

    public GarbageCollectCommand setPreserveOldPacks(boolean preserveOldPacks) {
        if (this.pconfig == null) {
            this.pconfig = new PackConfig(this.repo);
        }
        this.pconfig.setPreserveOldPacks(preserveOldPacks);
        return this;
    }

    public GarbageCollectCommand setPrunePreserved(boolean prunePreserved) {
        if (this.pconfig == null) {
            this.pconfig = new PackConfig(this.repo);
        }
        this.pconfig.setPrunePreserved(prunePreserved);
        return this;
    }

    @Override
    public Properties call() throws GitAPIException {
        this.checkCallable();
        try {
            if (this.repo instanceof FileRepository) {
                GC gc = new GC((FileRepository)this.repo);
                gc.setPackConfig(this.pconfig);
                gc.setProgressMonitor(this.monitor);
                if (this.expire != null) {
                    gc.setExpire(this.expire);
                }
                if (this.packKeptObjects != null) {
                    gc.setPackKeptObjects(this.packKeptObjects);
                }
                try {
                    gc.gc().get();
                    return GarbageCollectCommand.toProperties(gc.getStatistics());
                }
                catch (InterruptedException | ParseException | ExecutionException e) {
                    throw new JGitInternalException(JGitText.get().gcFailed, e);
                }
            }
            if (this.repo instanceof DfsRepository) {
                DfsGarbageCollector gc = new DfsGarbageCollector((DfsRepository)this.repo);
                gc.setPackConfig(this.pconfig);
                gc.pack(this.monitor);
                return new Properties();
            }
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedGC, this.repo.getClass().toString()));
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().gcFailed, e);
        }
    }

    public Properties getStatistics() throws GitAPIException {
        try {
            if (this.repo instanceof FileRepository) {
                GC gc = new GC((FileRepository)this.repo);
                return GarbageCollectCommand.toProperties(gc.getStatistics());
            }
            return new Properties();
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().couldNotGetRepoStatistics, e);
        }
    }

    private static Properties toProperties(GC.RepoStatistics stats) {
        Properties p = new Properties();
        p.put("numberOfBitmaps", (Object)stats.numberOfBitmaps);
        p.put("numberOfLooseObjects", (Object)stats.numberOfLooseObjects);
        p.put("numberOfLooseRefs", (Object)stats.numberOfLooseRefs);
        p.put("numberOfPackedObjects", (Object)stats.numberOfPackedObjects);
        p.put("numberOfPackedRefs", (Object)stats.numberOfPackedRefs);
        p.put("numberOfPackFiles", (Object)stats.numberOfPackFiles);
        p.put("sizeOfLooseObjects", (Object)stats.sizeOfLooseObjects);
        p.put("sizeOfPackedObjects", (Object)stats.sizeOfPackedObjects);
        return p;
    }
}

