/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.GitCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Ref;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    private final RevWalk rw;
    private RevCommit commit;

    protected ListTagCommand(Repository repo) {
        super(repo);
        this.rw = new RevWalk(repo);
    }

    public ListTagCommand setContains(AnyObjectId commit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        this.checkCallable();
        this.commit = this.rw.parseCommit(commit);
        return this;
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        List<Ref> tags;
        this.checkCallable();
        try {
            try {
                List<Ref> refList = this.repo.getRefDatabase().getRefsByPrefix("refs/tags/");
                if (this.commit != null) {
                    this.rw.setRetainBody(false);
                    tags = this.rw.getMergedInto(this.commit, refList);
                } else {
                    tags = new ArrayList<Ref>(refList);
                }
            }
            catch (IOException e) {
                throw new JGitInternalException(e.getMessage(), e);
            }
        }
        finally {
            this.rw.close();
        }
        Collections.sort(tags, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        this.setCallable(false);
        return tags;
    }
}

