/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.gitrepo;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.GitAPIException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.api.errors.JGitInternalException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCache;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.DirCacheEntry;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.dircache.InvalidPathException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.gitrepo.RepoCommand;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.gitrepo.RepoProject;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.gitrepo.internal.RepoText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.CommitBuilder;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Config;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.FileMode;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectInserter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.PersonIdent;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.RefUpdate;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Repository;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.FileUtils;

class BareSuperprojectWriter {
    private static final int LOCK_FAILURE_MAX_RETRIES = 5;
    private static final int LOCK_FAILURE_MIN_RETRY_DELAY_MILLIS = 50;
    private static final int LOCK_FAILURE_MAX_RETRY_DELAY_MILLIS = 5000;
    private final Repository repo;
    private final URI targetUri;
    private final String targetBranch;
    private final RepoCommand.RemoteReader callback;
    private final BareWriterConfig config;
    private final PersonIdent author;
    private List<ExtraContent> extraContents;

    BareSuperprojectWriter(Repository repo, URI targetUri, String targetBranch, PersonIdent author, RepoCommand.RemoteReader callback, BareWriterConfig config, List<ExtraContent> extraContents) {
        assert (repo.isBare());
        this.repo = repo;
        this.targetUri = targetUri;
        this.targetBranch = targetBranch;
        this.author = author;
        this.callback = callback;
        this.config = config;
        this.extraContents = extraContents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RevCommit write(List<RepoProject> repoProjects) throws GitAPIException {
        DirCache index = DirCache.newInCore();
        ObjectInserter inserter = this.repo.newObjectInserter();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk rw = new RevWalk(this.repo);){
                this.prepareIndex(repoProjects, index, inserter);
                ObjectId treeId = index.writeTree(inserter);
                long prevDelay = 0L;
                int i = 0;
                while (i < 4) {
                    try {
                        return this.commitTreeOnCurrentTip(inserter, rw, treeId);
                    }
                    catch (ConcurrentRefUpdateException e) {
                        try {
                            prevDelay = FileUtils.delay(prevDelay, 50L, 5000L);
                            Thread.sleep(prevDelay);
                            this.repo.getRefDatabase().refresh();
                            ++i;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                            return this.commitTreeOnCurrentTip(inserter, rw, treeId);
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException | InvalidPathException e) {
            throw new RepoCommand.ManifestErrorException(e);
        }
    }

    private void prepareIndex(List<RepoProject> projects, DirCache index, ObjectInserter inserter) throws IOException, GitAPIException {
        Config cfg = new Config();
        StringBuilder attributes = new StringBuilder();
        DirCacheBuilder builder = index.builder();
        for (RepoProject proj : projects) {
            ObjectId objectId;
            String name = proj.getName();
            String path = proj.getPath();
            String url = proj.getUrl();
            if (ObjectId.isId(proj.getRevision())) {
                objectId = ObjectId.fromString(proj.getRevision());
            } else {
                objectId = this.callback.sha1(url, proj.getRevision());
                if (objectId == null && !this.config.ignoreRemoteFailures) {
                    throw new RepoCommand.RemoteUnavailableException(url);
                }
                if (this.config.recordRemoteBranch) {
                    String field = proj.getRevision().startsWith("refs/tags/") ? "ref" : "branch";
                    cfg.setString("submodule", name, field, proj.getRevision());
                }
                if (this.config.recordShallowSubmodules && proj.getRecommendShallow() != null) {
                    cfg.setBoolean("submodule", name, "shallow", true);
                }
            }
            if (this.config.recordSubmoduleLabels) {
                StringBuilder rec = new StringBuilder();
                rec.append("/");
                rec.append(path);
                for (String group : proj.getGroups()) {
                    rec.append(" ");
                    rec.append(group);
                }
                rec.append("\n");
                attributes.append(rec.toString());
            }
            URI submodUrl = URI.create(url);
            if (this.targetUri != null) {
                submodUrl = RepoCommand.relativize(this.targetUri, submodUrl);
            }
            cfg.setString("submodule", name, "path", path);
            cfg.setString("submodule", name, "url", submodUrl.toString());
            if (objectId == null) continue;
            DirCacheEntry dcEntry = new DirCacheEntry(path);
            dcEntry.setObjectId(objectId);
            dcEntry.setFileMode(FileMode.GITLINK);
            builder.add(dcEntry);
            for (RepoProject.CopyFile copyfile : proj.getCopyFiles()) {
                RepoCommand.RemoteFile rf = this.callback.readFileWithMode(url, proj.getRevision(), copyfile.src);
                objectId = inserter.insert(3, rf.getContents());
                dcEntry = new DirCacheEntry(copyfile.dest);
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(rf.getFileMode());
                builder.add(dcEntry);
            }
            for (RepoProject.LinkFile linkfile : proj.getLinkFiles()) {
                Object link = linkfile.dest.contains("/") ? FileUtils.relativizeGitPath(linkfile.dest.substring(0, linkfile.dest.lastIndexOf(47)), proj.getPath() + "/" + linkfile.src) : proj.getPath() + "/" + linkfile.src;
                objectId = inserter.insert(3, ((String)link).getBytes(StandardCharsets.UTF_8));
                dcEntry = new DirCacheEntry(linkfile.dest);
                dcEntry.setObjectId(objectId);
                dcEntry.setFileMode(FileMode.SYMLINK);
                builder.add(dcEntry);
            }
        }
        String content = cfg.toText();
        DirCacheEntry dcEntry = new DirCacheEntry(".gitmodules");
        ObjectId objectId = inserter.insert(3, content.getBytes(StandardCharsets.UTF_8));
        dcEntry.setObjectId(objectId);
        dcEntry.setFileMode(FileMode.REGULAR_FILE);
        builder.add(dcEntry);
        if (this.config.recordSubmoduleLabels) {
            DirCacheEntry dcEntryAttr = new DirCacheEntry(".gitattributes");
            ObjectId attrId = inserter.insert(3, attributes.toString().getBytes(StandardCharsets.UTF_8));
            dcEntryAttr.setObjectId(attrId);
            dcEntryAttr.setFileMode(FileMode.REGULAR_FILE);
            builder.add(dcEntryAttr);
        }
        for (ExtraContent ec : this.extraContents) {
            DirCacheEntry extraDcEntry = new DirCacheEntry(ec.path);
            ObjectId oid = inserter.insert(3, ec.content.getBytes(StandardCharsets.UTF_8));
            extraDcEntry.setObjectId(oid);
            extraDcEntry.setFileMode(FileMode.REGULAR_FILE);
            builder.add(extraDcEntry);
        }
        builder.finish();
    }

    private RevCommit commitTreeOnCurrentTip(ObjectInserter inserter, RevWalk rw, ObjectId treeId) throws IOException, ConcurrentRefUpdateException {
        ObjectId headId = this.repo.resolve(this.targetBranch + "^{commit}");
        if (headId != null && rw.parseCommit(headId).getTree().getId().equals(treeId)) {
            return rw.parseCommit(headId);
        }
        CommitBuilder commit = new CommitBuilder();
        commit.setTreeId(treeId);
        if (headId != null) {
            commit.setParentIds(headId);
        }
        commit.setAuthor(this.author);
        commit.setCommitter(this.author);
        commit.setMessage(RepoText.get().repoCommitMessage);
        ObjectId commitId = inserter.insert(commit);
        inserter.flush();
        RefUpdate ru = this.repo.updateRef(this.targetBranch);
        ru.setNewObjectId(commitId);
        ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
        RefUpdate.Result rc = ru.update(rw);
        switch (rc) {
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                break;
            }
            case LOCK_FAILURE: 
            case REJECTED: {
                throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, this.targetBranch), ru.getRef(), rc);
            }
            default: {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, commitId.name(), rc}));
            }
        }
        return rw.parseCommit(commitId);
    }

    static class BareWriterConfig {
        boolean ignoreRemoteFailures = false;
        boolean recordRemoteBranch = true;
        boolean recordSubmoduleLabels = true;
        boolean recordShallowSubmodules = true;

        static BareWriterConfig getDefault() {
            return new BareWriterConfig();
        }

        private BareWriterConfig() {
        }
    }

    static class ExtraContent {
        final String path;
        final String content;

        ExtraContent(String path, String content) {
            this.path = path;
            this.content = content;
        }
    }
}

