/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.NonNull;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.commitgraph.CommitGraph;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.commitgraph.CommitGraphFormatException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.commitgraph.CommitGraphLoader;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.FileSnapshot;
import se.bjurr.violations.violationsgitlib.org.slf4j.Logger;
import se.bjurr.violations.violationsgitlib.org.slf4j.LoggerFactory;

public class FileCommitGraph {
    private static final Logger LOG = LoggerFactory.getLogger(FileCommitGraph.class);
    private final AtomicReference<GraphSnapshot> baseGraph;

    FileCommitGraph(File objectsDir) {
        this.baseGraph = new AtomicReference<GraphSnapshot>(new GraphSnapshot(new File(objectsDir, "info/commit-graph")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CommitGraph get() {
        GraphSnapshot original = this.baseGraph.get();
        AtomicReference<GraphSnapshot> atomicReference = this.baseGraph;
        synchronized (atomicReference) {
            GraphSnapshot n;
            GraphSnapshot o;
            do {
                if ((o = this.baseGraph.get()) != original) {
                    return o.getCommitGraph();
                }
                n = o.refresh();
                if (n != o) continue;
                return n.getCommitGraph();
            } while (!this.baseGraph.compareAndSet(o, n));
            return n.getCommitGraph();
        }
    }

    private static final class GraphSnapshot {
        private final File file;
        private final FileSnapshot snapshot;
        private final CommitGraph graph;

        GraphSnapshot(@NonNull File file) {
            this(file, null, null);
        }

        GraphSnapshot(@NonNull File file, FileSnapshot snapshot, CommitGraph graph) {
            this.file = file;
            this.snapshot = snapshot;
            this.graph = graph;
        }

        CommitGraph getCommitGraph() {
            return this.graph;
        }

        GraphSnapshot refresh() {
            if (this.graph == null && !this.file.exists()) {
                return this;
            }
            if (this.snapshot != null && !this.snapshot.isModified(this.file)) {
                return this;
            }
            return new GraphSnapshot(this.file, FileSnapshot.save(this.file), GraphSnapshot.open(this.file));
        }

        private static CommitGraph open(File file) {
            try {
                return CommitGraphLoader.open(file);
            }
            catch (FileNotFoundException noFile) {
                return null;
            }
            catch (IOException e) {
                if (e instanceof CommitGraphFormatException) {
                    LOG.warn(MessageFormat.format(JGitText.get().corruptCommitGraph, file), e);
                } else {
                    LOG.error(MessageFormat.format(JGitText.get().exceptionWhileLoadingCommitGraph, file), e);
                }
                return null;
            }
        }
    }
}

