/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file;

import java.text.MessageFormat;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.CorruptObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.PackMismatchException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.PackIndex;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;

final class PackReverseIndexComputed
implements PackReverseIndex {
    private final PackIndex index;
    private final long bucketSize;
    private final int[] nextBucketStart;
    private final int[] indexPosInOffsetOrder;

    PackReverseIndexComputed(PackIndex packIndex) {
        this.index = packIndex;
        long rawCnt = this.index.getObjectCount();
        if (rawCnt + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(JGitText.get().hugeIndexesAreNotSupportedByJgitYet);
        }
        int cnt = (int)rawCnt;
        if (cnt == 0) {
            this.bucketSize = Long.MAX_VALUE;
            this.nextBucketStart = new int[1];
            this.indexPosInOffsetOrder = new int[0];
            return;
        }
        long[] offsetsInIndexOrder = new long[cnt];
        long maxOffset = 0L;
        int i = 0;
        for (PackIndex.MutableEntry entry : this.index) {
            long offset = entry.getOffset();
            offsetsInIndexOrder[i++] = offset;
            if (offset <= maxOffset) continue;
            maxOffset = offset;
        }
        this.bucketSize = maxOffset / (long)cnt + 1L;
        int[] headValues = new int[cnt];
        int[] furtherValues = new int[cnt + 1];
        int indexPos = 0;
        while (indexPos < cnt) {
            long offset = offsetsInIndexOrder[indexPos];
            int bucket = (int)(offset / this.bucketSize);
            int asBucketValue = indexPos + 1;
            int current = headValues[bucket];
            headValues[bucket] = asBucketValue;
            furtherValues[asBucketValue] = current;
            ++indexPos;
        }
        int nthByOffset = 0;
        this.indexPosInOffsetOrder = new int[cnt];
        this.nextBucketStart = headValues;
        int bi = 0;
        while (bi < headValues.length) {
            int start = nthByOffset;
            int vi = headValues[bi];
            while (vi > 0) {
                int nthBySha1 = vi - 1;
                long o = offsetsInIndexOrder[nthBySha1];
                int insertion = nthByOffset++;
                while (start < insertion) {
                    if (o > offsetsInIndexOrder[this.indexPosInOffsetOrder[insertion - 1]]) break;
                    this.indexPosInOffsetOrder[insertion] = this.indexPosInOffsetOrder[insertion - 1];
                    --insertion;
                }
                this.indexPosInOffsetOrder[insertion] = nthBySha1;
                vi = furtherValues[vi];
            }
            this.nextBucketStart[bi] = nthByOffset;
            ++bi;
        }
    }

    @Override
    public void verifyPackChecksum(String packFilePath) throws PackMismatchException {
    }

    @Override
    public ObjectId findObject(long offset) {
        int ith = this.binarySearch(offset);
        if (ith < 0) {
            return null;
        }
        return this.index.getObjectId(this.indexPosInOffsetOrder[ith]);
    }

    @Override
    public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
        int ith = this.binarySearch(offset);
        if (ith < 0) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().cantFindObjectInReversePackIndexForTheSpecifiedOffset, offset));
        }
        if (ith + 1 == this.indexPosInOffsetOrder.length) {
            return maxOffset;
        }
        return this.index.getOffset(this.indexPosInOffsetOrder[ith + 1]);
    }

    @Override
    public int findPosition(long offset) {
        return this.binarySearch(offset);
    }

    private int binarySearch(long offset) {
        int bucket = (int)(offset / this.bucketSize);
        int low = bucket == 0 ? 0 : this.nextBucketStart[bucket - 1];
        int high = this.nextBucketStart[bucket];
        while (low < high) {
            int mid = low + high >>> 1;
            long o = this.index.getOffset(this.indexPosInOffsetOrder[mid]);
            if (offset < o) {
                high = mid;
                continue;
            }
            if (offset == o) {
                return mid;
            }
            low = mid + 1;
        }
        return -1;
    }

    @Override
    public ObjectId findObjectByPosition(int nthPosition) {
        return this.index.getObjectId(this.indexPosInOffsetOrder[nthPosition]);
    }
}

