/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.io.OutputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.io.CancellableDigestOutputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.pack.PackWriter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Constants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ProgressMonitor;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.NB;

public final class PackOutputStream
extends CancellableDigestOutputStream {
    private final PackWriter packWriter;
    private final byte[] headerBuffer = new byte[32];
    private final byte[] copyBuffer = new byte[65536];
    private boolean ofsDelta;

    public PackOutputStream(ProgressMonitor writeMonitor, OutputStream out, PackWriter pw) {
        super(writeMonitor, out);
        this.packWriter = pw;
    }

    final void writeFileHeader(int version, long objectCount) throws IOException {
        System.arraycopy(Constants.PACK_SIGNATURE, 0, this.headerBuffer, 0, 4);
        NB.encodeInt32(this.headerBuffer, 4, version);
        NB.encodeInt32(this.headerBuffer, 8, (int)objectCount);
        this.write(this.headerBuffer, 0, 12);
        this.ofsDelta = this.packWriter.isDeltaBaseAsOffset();
    }

    public final void writeObject(ObjectToPack otp) throws IOException {
        this.packWriter.writeObject(this, otp);
    }

    public final void writeHeader(ObjectToPack otp, long rawLength) throws IOException {
        ObjectToPack b = otp.getDeltaBase();
        if (b != null && b.isWritten() & this.ofsDelta) {
            int n = PackOutputStream.objectHeader(rawLength, 6, this.headerBuffer);
            n = PackOutputStream.ofsDelta(this.length() - b.getOffset(), this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n);
        } else if (otp.isDeltaRepresentation()) {
            int n = PackOutputStream.objectHeader(rawLength, 7, this.headerBuffer);
            otp.getDeltaBaseId().copyRawTo(this.headerBuffer, n);
            this.write(this.headerBuffer, 0, n + 20);
        } else {
            int n = PackOutputStream.objectHeader(rawLength, otp.getType(), this.headerBuffer);
            this.write(this.headerBuffer, 0, n);
        }
    }

    private static final int objectHeader(long len, int type, byte[] buf) {
        byte b = (byte)((long)(type << 4) | len & 0xFL);
        int n = 0;
        len >>>= 4;
        while (len != 0L) {
            buf[n++] = (byte)(0x80 | b);
            b = (byte)(len & 0x7FL);
            len >>>= 7;
        }
        buf[n++] = b;
        return n;
    }

    private static final int ofsDelta(long diff, byte[] buf, int p) {
        int n = p += PackOutputStream.ofsDeltaVarIntLength(diff);
        buf[--n] = (byte)(diff & 0x7FL);
        while ((diff >>>= 7) != 0L) {
            buf[--n] = (byte)(0x80L | --diff & 0x7FL);
        }
        return p;
    }

    private static final int ofsDeltaVarIntLength(long v) {
        int n = 1;
        while ((v >>>= 7) != 0L) {
            --v;
            ++n;
        }
        return n;
    }

    public final byte[] getCopyBuffer() {
        return this.copyBuffer;
    }

    void endObject() {
        this.getWriteMonitor().update(1);
    }
}

