/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.Nullable;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable.BlockSizeTooSmallException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable.BlockWriter;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AbbreviatedObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.AnyObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectId;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.ObjectIdSubclassMap;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.PersonIdent;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Ref;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.LongList;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.NB;

public class ReftableWriter {
    private ReftableConfig config;
    private int refBlockSize;
    private int logBlockSize;
    private int restartInterval;
    private int maxIndexLevels;
    private boolean alignBlocks;
    private boolean indexObjects;
    private long minUpdateIndex;
    private long maxUpdateIndex;
    private OutputStream outputStream;
    private ReftableOutputStream out;
    private ObjectIdSubclassMap<RefList> obj2ref;
    private BlockWriter.Entry lastRef;
    private BlockWriter.Entry lastLog;
    private BlockWriter cur;
    private Section refs;
    private Section objs;
    private Section logs;
    private int objIdLen;
    private Stats stats;

    public ReftableWriter(OutputStream os) {
        this(new ReftableConfig(), os);
        this.lastRef = null;
        this.lastLog = null;
    }

    public ReftableWriter(ReftableConfig cfg, OutputStream os) {
        this.config = cfg;
        this.outputStream = os;
    }

    public ReftableWriter setConfig(ReftableConfig cfg) {
        this.config = cfg != null ? cfg : new ReftableConfig();
        return this;
    }

    public ReftableWriter setMinUpdateIndex(long min) {
        this.minUpdateIndex = min;
        return this;
    }

    public ReftableWriter setMaxUpdateIndex(long max) {
        this.maxUpdateIndex = max;
        return this;
    }

    public ReftableWriter begin() {
        if (this.out != null) {
            throw new IllegalStateException("begin() called twice.");
        }
        this.refBlockSize = this.config.getRefBlockSize();
        this.logBlockSize = this.config.getLogBlockSize();
        this.restartInterval = this.config.getRestartInterval();
        this.maxIndexLevels = this.config.getMaxIndexLevels();
        this.alignBlocks = this.config.isAlignBlocks();
        this.indexObjects = this.config.isIndexObjects();
        if (this.refBlockSize <= 0) {
            this.refBlockSize = 4096;
        } else if (this.refBlockSize > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        if (this.logBlockSize <= 0) {
            this.logBlockSize = 2 * this.refBlockSize;
        }
        if (this.restartInterval <= 0) {
            this.restartInterval = this.refBlockSize < 61440 ? 16 : 64;
        }
        this.out = new ReftableOutputStream(this.outputStream, this.refBlockSize, this.alignBlocks);
        this.refs = new Section(114);
        if (this.indexObjects) {
            this.obj2ref = new ObjectIdSubclassMap();
        }
        this.writeFileHeader();
        return this;
    }

    public ReftableWriter sortAndWriteRefs(Collection<Ref> refsToPack) throws IOException {
        Iterator itr = refsToPack.stream().map(r -> new BlockWriter.RefEntry((Ref)r, this.maxUpdateIndex - this.minUpdateIndex)).sorted(BlockWriter.Entry::compare).iterator();
        BlockWriter.RefEntry last = null;
        while (itr.hasNext()) {
            BlockWriter.RefEntry entry = (BlockWriter.RefEntry)itr.next();
            if (last != null && BlockWriter.Entry.compare(last, entry) == 0) {
                this.throwIllegalEntry(last, entry);
            }
            long blockPos = this.refs.write(entry);
            this.indexRef(entry.ref, blockPos);
            last = entry;
        }
        return this;
    }

    public void writeRef(Ref ref) throws IOException {
        this.writeRef(ref, this.maxUpdateIndex);
    }

    public void writeRef(Ref ref, long updateIndex) throws IOException {
        if (updateIndex < this.minUpdateIndex) {
            throw new IllegalArgumentException();
        }
        long d = updateIndex - this.minUpdateIndex;
        BlockWriter.RefEntry entry = new BlockWriter.RefEntry(ref, d);
        if (this.lastRef != null && BlockWriter.Entry.compare(this.lastRef, entry) >= 0) {
            this.throwIllegalEntry(this.lastRef, entry);
        }
        this.lastRef = entry;
        long blockPos = this.refs.write(entry);
        this.indexRef(ref, blockPos);
    }

    private void throwIllegalEntry(BlockWriter.Entry last, BlockWriter.Entry now) {
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().reftableRecordsMustIncrease, new String(last.key, StandardCharsets.UTF_8), new String(now.key, StandardCharsets.UTF_8)));
    }

    private void indexRef(Ref ref, long blockPos) {
        if (this.indexObjects && !ref.isSymbolic()) {
            this.indexId(ref.getObjectId(), blockPos);
            this.indexId(ref.getPeeledObjectId(), blockPos);
        }
    }

    private void indexId(ObjectId id, long blockPos) {
        if (id != null) {
            RefList l = this.obj2ref.get(id);
            if (l == null) {
                l = new RefList(id);
                this.obj2ref.add(l);
            }
            l.addBlock(blockPos);
        }
    }

    public void writeLog(String ref, long updateIndex, PersonIdent who, ObjectId oldId, ObjectId newId, @Nullable String message) throws IOException {
        String msg = message != null ? message : "";
        this.beginLog();
        BlockWriter.LogEntry entry = new BlockWriter.LogEntry(ref, updateIndex, who, oldId, newId, msg);
        if (this.lastLog != null && BlockWriter.Entry.compare(this.lastLog, entry) >= 0) {
            this.throwIllegalEntry(this.lastLog, entry);
        }
        this.lastLog = entry;
        this.logs.write(entry);
    }

    public void deleteLog(String ref, long updateIndex) throws IOException {
        this.beginLog();
        this.logs.write(new BlockWriter.DeleteLogEntry(ref, updateIndex));
    }

    private void beginLog() throws IOException {
        if (this.logs == null) {
            this.finishRefAndObjSections();
            this.out.flushFileHeader();
            this.out.setBlockSize(this.logBlockSize);
            this.logs = new Section(103);
        }
    }

    public long estimateTotalBytes() {
        long bytes = this.out.size();
        if (bytes == 0L) {
            bytes += 24L;
        }
        if (this.cur != null) {
            long curBlockPos = this.out.size();
            int sz = this.cur.currentSize();
            bytes += (long)sz;
            IndexBuilder idx = null;
            if (this.cur.blockType() == 114) {
                idx = this.refs.idx;
            } else if (this.cur.blockType() == 103) {
                idx = this.logs.idx;
            }
            if (idx != null && this.shouldHaveIndex(idx)) {
                if (idx == this.refs.idx) {
                    bytes += (long)this.out.estimatePadBetweenBlocks(sz);
                }
                bytes += (long)idx.estimateBytes(curBlockPos);
            }
        }
        return bytes += 68L;
    }

    public ReftableWriter finish() throws IOException {
        this.finishRefAndObjSections();
        this.finishLogSection();
        this.writeFileFooter();
        this.out.finishFile();
        this.stats = new Stats(this, this.out);
        this.out = null;
        this.obj2ref = null;
        this.cur = null;
        this.refs = null;
        this.objs = null;
        this.logs = null;
        return this;
    }

    private void finishRefAndObjSections() throws IOException {
        if (this.cur != null && this.cur.blockType() == 114) {
            this.refs.finishSectionMaybeWriteIndex();
            if (this.indexObjects && !this.obj2ref.isEmpty() && this.refs.idx.bytes > 0) {
                this.writeObjBlocks();
            }
            this.obj2ref = null;
        }
    }

    private void writeObjBlocks() throws IOException {
        List<RefList> sorted = ReftableWriter.sortById(this.obj2ref);
        this.obj2ref = null;
        this.objIdLen = ReftableWriter.shortestUniqueAbbreviation(sorted);
        this.out.padBetweenBlocksToNextBlock();
        this.objs = new Section(111);
        this.objs.entryCnt = sorted.size();
        for (RefList l : sorted) {
            this.objs.write(new BlockWriter.ObjEntry(this.objIdLen, l, l.blockPos));
        }
        this.objs.finishSectionMaybeWriteIndex();
    }

    private void finishLogSection() throws IOException {
        if (this.cur != null && this.cur.blockType() == 103) {
            this.logs.finishSectionMaybeWriteIndex();
        }
    }

    private boolean shouldHaveIndex(IndexBuilder idx) {
        int threshold = idx == this.refs.idx && this.alignBlocks ? 4 : 1;
        return idx.entries.size() + (this.cur != null ? 1 : 0) > threshold;
    }

    private void writeFileHeader() {
        byte[] hdr = new byte[24];
        this.encodeHeader(hdr);
        this.out.write(hdr, 0, 24);
    }

    private void encodeHeader(byte[] hdr) {
        System.arraycopy(ReftableConstants.FILE_HEADER_MAGIC, 0, hdr, 0, 4);
        int bs = this.alignBlocks ? this.refBlockSize : 0;
        NB.encodeInt32(hdr, 4, 0x1000000 | bs);
        NB.encodeInt64(hdr, 8, this.minUpdateIndex);
        NB.encodeInt64(hdr, 16, this.maxUpdateIndex);
    }

    private void writeFileFooter() {
        int ftrLen = 68;
        byte[] ftr = new byte[ftrLen];
        this.encodeHeader(ftr);
        NB.encodeInt64(ftr, 24, ReftableWriter.indexPosition(this.refs));
        NB.encodeInt64(ftr, 32, ReftableWriter.firstBlockPosition(this.objs) << 5 | (long)this.objIdLen);
        NB.encodeInt64(ftr, 40, ReftableWriter.indexPosition(this.objs));
        NB.encodeInt64(ftr, 48, ReftableWriter.firstBlockPosition(this.logs));
        NB.encodeInt64(ftr, 56, ReftableWriter.indexPosition(this.logs));
        CRC32 crc = new CRC32();
        crc.update(ftr, 0, ftrLen - 4);
        NB.encodeInt32(ftr, ftrLen - 4, (int)crc.getValue());
        this.out.write(ftr, 0, ftrLen);
    }

    private static long firstBlockPosition(@Nullable Section s) {
        return s != null ? s.firstBlockPosition : 0L;
    }

    private static long indexPosition(@Nullable Section s) {
        return s != null && s.idx != null ? s.idx.rootPosition : 0L;
    }

    public Stats getStats() {
        return this.stats;
    }

    private static List<RefList> sortById(ObjectIdSubclassMap<RefList> m) {
        ArrayList<RefList> s = new ArrayList<RefList>(m.size());
        for (RefList l : m) {
            s.add(l);
        }
        Collections.sort(s);
        return s;
    }

    private static int shortestUniqueAbbreviation(List<RefList> in) {
        int bytes = Math.max(2, (int)(Math.log(in.size()) / Math.log(8.0)));
        HashSet<AbbreviatedObjectId> tmp = new HashSet<AbbreviatedObjectId>((int)((float)in.size() * 0.75f));
        block0: while (true) {
            int hexLen = bytes * 2;
            for (ObjectId objectId : in) {
                AbbreviatedObjectId a = objectId.abbreviate(hexLen);
                if (tmp.add(a)) continue;
                if (++bytes >= 20) {
                    return 20;
                }
                tmp.clear();
                continue block0;
            }
            break;
        }
        return bytes;
    }

    private class IndexBuilder {
        final byte keyType;
        List<BlockWriter.IndexEntry> entries = new ArrayList<BlockWriter.IndexEntry>();
        long rootPosition;
        int bytes;
        int levels;

        IndexBuilder(byte kt) {
            this.keyType = kt;
        }

        int estimateBytes(long curBlockPos) {
            BlockWriter b = new BlockWriter(105, this.keyType, 0xFFFFFF, Math.max(ReftableWriter.this.restartInterval, this.entries.size() / 65535));
            try {
                for (BlockWriter.Entry entry : this.entries) {
                    b.mustAdd(entry);
                }
                if (ReftableWriter.this.cur != null) {
                    b.mustAdd(new BlockWriter.IndexEntry(ReftableWriter.this.cur.lastKey(), curBlockPos));
                }
            }
            catch (BlockSizeTooSmallException blockSizeTooSmallException) {
                return b.currentSize();
            }
            return b.currentSize();
        }

        void writeIndex() throws IOException {
            if (BlockWriter.padBetweenBlocks(this.keyType)) {
                ReftableWriter.this.out.padBetweenBlocksToNextBlock();
            }
            long startPos = ReftableWriter.this.out.size();
            this.writeMultiLevelIndex(this.entries);
            this.bytes = (int)(ReftableWriter.this.out.size() - startPos);
            this.entries = null;
        }

        private void writeMultiLevelIndex(List<BlockWriter.IndexEntry> keys) throws IOException {
            this.levels = 1;
            while (ReftableWriter.this.maxIndexLevels == 0 || this.levels < ReftableWriter.this.maxIndexLevels) {
                if ((keys = this.writeOneLevel(keys)) == null) {
                    return;
                }
                ++this.levels;
            }
            BlockWriter b = new BlockWriter(105, this.keyType, 0xFFFFFF, Math.max(ReftableWriter.this.restartInterval, keys.size() / 65535));
            for (BlockWriter.Entry entry : keys) {
                b.mustAdd(entry);
            }
            this.rootPosition = ReftableWriter.this.out.size();
            b.writeTo(ReftableWriter.this.out);
        }

        private List<BlockWriter.IndexEntry> writeOneLevel(List<BlockWriter.IndexEntry> keys) throws IOException {
            Section thisLevel = new Section(this.keyType);
            for (BlockWriter.Entry entry : keys) {
                thisLevel.write(entry);
            }
            if (!thisLevel.idx.entries.isEmpty()) {
                thisLevel.flushCurBlock();
                if (ReftableWriter.this.cur.padBetweenBlocks()) {
                    ReftableWriter.this.out.padBetweenBlocksToNextBlock();
                }
                ReftableWriter.this.cur = null;
                return thisLevel.idx.entries;
            }
            this.rootPosition = ReftableWriter.this.out.size();
            ReftableWriter.this.cur.writeTo(ReftableWriter.this.out);
            ReftableWriter.this.cur = null;
            return null;
        }
    }

    private static class RefList
    extends ObjectIdOwnerMap.Entry {
        final LongList blockPos = new LongList(2);

        RefList(AnyObjectId id) {
            super(id);
        }

        void addBlock(long pos) {
            if (!this.blockPos.contains(pos)) {
                this.blockPos.add(pos);
            }
        }
    }

    private class Section {
        final IndexBuilder idx;
        final long firstBlockPosition;
        long entryCnt;
        long bytes;

        Section(byte keyType) {
            this.idx = new IndexBuilder(keyType);
            this.firstBlockPosition = ReftableWriter.this.out.size();
        }

        long write(BlockWriter.Entry entry) throws IOException {
            if (ReftableWriter.this.cur == null) {
                this.beginBlock(entry);
            } else if (!ReftableWriter.this.cur.tryAdd(entry)) {
                this.flushCurBlock();
                if (ReftableWriter.this.cur.padBetweenBlocks()) {
                    ReftableWriter.this.out.padBetweenBlocksToNextBlock();
                }
                this.beginBlock(entry);
            }
            ++this.entryCnt;
            return ReftableWriter.this.out.size();
        }

        private void beginBlock(BlockWriter.Entry entry) throws BlockSizeTooSmallException {
            byte blockType = entry.blockType();
            int bs = ReftableWriter.this.out.bytesAvailableInBlock();
            ReftableWriter.this.cur = new BlockWriter(blockType, this.idx.keyType, bs, ReftableWriter.this.restartInterval);
            ReftableWriter.this.cur.mustAdd(entry);
        }

        void flushCurBlock() throws IOException {
            this.idx.entries.add(new BlockWriter.IndexEntry(ReftableWriter.this.cur.lastKey(), ReftableWriter.this.out.size()));
            ReftableWriter.this.cur.writeTo(ReftableWriter.this.out);
        }

        void finishSectionMaybeWriteIndex() throws IOException {
            this.flushCurBlock();
            ReftableWriter.this.cur = null;
            if (ReftableWriter.this.shouldHaveIndex(this.idx)) {
                this.idx.writeIndex();
            }
            this.bytes = ReftableWriter.this.out.size() - this.firstBlockPosition;
        }
    }

    public static class Stats {
        private final int refBlockSize;
        private final int logBlockSize;
        private final int restartInterval;
        private final long minUpdateIndex;
        private final long maxUpdateIndex;
        private final long refCnt;
        private final long objCnt;
        private final int objIdLen;
        private final long logCnt;
        private final long refBytes;
        private final long objBytes;
        private final long logBytes;
        private final long paddingUsed;
        private final long totalBytes;
        private final int refIndexSize;
        private final int refIndexLevels;
        private final int objIndexSize;
        private final int objIndexLevels;

        Stats(ReftableWriter w, ReftableOutputStream o) {
            this.refBlockSize = w.refBlockSize;
            this.logBlockSize = w.logBlockSize;
            this.restartInterval = w.restartInterval;
            this.minUpdateIndex = w.minUpdateIndex;
            this.maxUpdateIndex = w.maxUpdateIndex;
            this.paddingUsed = o.paddingUsed();
            this.totalBytes = o.size();
            this.refCnt = w.refs.entryCnt;
            this.refBytes = w.refs.bytes;
            this.objCnt = w.objs != null ? w.objs.entryCnt : 0L;
            this.objBytes = w.objs != null ? w.objs.bytes : 0L;
            this.objIdLen = w.objIdLen;
            this.logCnt = w.logs != null ? w.logs.entryCnt : 0L;
            this.logBytes = w.logs != null ? w.logs.bytes : 0L;
            IndexBuilder refIdx = w.refs.idx;
            this.refIndexSize = refIdx.bytes;
            this.refIndexLevels = refIdx.levels;
            IndexBuilder objIdx = w.objs != null ? w.objs.idx : null;
            this.objIndexSize = objIdx != null ? objIdx.bytes : 0;
            this.objIndexLevels = objIdx != null ? objIdx.levels : 0;
        }

        public int refBlockSize() {
            return this.refBlockSize;
        }

        public int logBlockSize() {
            return this.logBlockSize;
        }

        public int restartInterval() {
            return this.restartInterval;
        }

        public long minUpdateIndex() {
            return this.minUpdateIndex;
        }

        public long maxUpdateIndex() {
            return this.maxUpdateIndex;
        }

        public long refCount() {
            return this.refCnt;
        }

        public long objCount() {
            return this.objCnt;
        }

        public long logCount() {
            return this.logCnt;
        }

        public long refBytes() {
            return this.refBytes;
        }

        public long objBytes() {
            return this.objBytes;
        }

        public long logBytes() {
            return this.logBytes;
        }

        public long totalBytes() {
            return this.totalBytes;
        }

        public long paddingBytes() {
            return this.paddingUsed;
        }

        public int refIndexSize() {
            return this.refIndexSize;
        }

        public int refIndexLevels() {
            return this.refIndexLevels;
        }

        public int objIndexSize() {
            return this.objIndexSize;
        }

        public int objIndexLevels() {
            return this.objIndexLevels;
        }

        public int objIdLength() {
            return this.objIdLen;
        }
    }
}

