/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.FooterKey;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util.RawParseUtils;

public final class FooterLine {
    private final byte[] buffer;
    private final Charset enc;
    private final int keyStart;
    private final int keyEnd;
    private final int valStart;
    private final int valEnd;

    FooterLine(byte[] b, Charset e, int ks, int ke, int vs, int ve) {
        this.buffer = b;
        this.enc = e;
        this.keyStart = ks;
        this.keyEnd = ke;
        this.valStart = vs;
        this.valEnd = ve;
    }

    public static List<FooterLine> fromMessage(String str) {
        return FooterLine.fromMessage(str.getBytes());
    }

    public static List<FooterLine> fromMessage(byte[] raw) {
        int parEnd = raw.length;
        while (parEnd > 0 && (raw[parEnd - 1] == 10 || raw[parEnd - 1] == 32)) {
            --parEnd;
        }
        int msgB = RawParseUtils.nextLfSkippingSplitLines(raw, RawParseUtils.hasAnyKnownHeaders(raw) ? RawParseUtils.commitMessage(raw, 0) : 0);
        ArrayList<FooterLine> r = new ArrayList<FooterLine>(4);
        Charset enc = RawParseUtils.guessEncoding(raw);
        int parStart = parEnd;
        while (parStart > msgB) {
            if (parStart < 2) {
                parStart = 0;
                break;
            }
            if (raw[parStart - 1] == 10 && raw[parStart - 2] == 10) break;
            --parStart;
        }
        int ptr = parStart;
        while (ptr < parEnd) {
            int valEnd;
            int keyStart = ptr;
            int keyEnd = RawParseUtils.endOfFooterLineKey(raw, ptr);
            if (keyEnd < 0) {
                ptr = RawParseUtils.nextLF(raw, ptr);
                continue;
            }
            int valStart = keyEnd + 1;
            while (valStart < raw.length && raw[valStart] == 32) {
                ++valStart;
            }
            ptr = valStart;
            while ((ptr = RawParseUtils.nextLF(raw, ptr)) != raw.length && raw[ptr] == 32) {
            }
            int n = valEnd = raw[ptr - 1] == 10 ? ptr - 1 : ptr;
            if (keyStart == msgB) continue;
            r.add(new FooterLine(raw, enc, keyStart, keyEnd, valStart, valEnd));
        }
        return r;
    }

    public static List<String> getValues(List<FooterLine> footers, String keyName) {
        return FooterLine.getValues(footers, new FooterKey(keyName));
    }

    public static List<String> getValues(List<FooterLine> footers, FooterKey key) {
        if (footers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> r = new ArrayList<String>(footers.size());
        for (FooterLine f : footers) {
            if (!f.matches(key)) continue;
            r.add(f.getValue());
        }
        return r;
    }

    public boolean matches(FooterKey key) {
        int bPtr = this.keyStart;
        byte[] kRaw = key.raw;
        int len = kRaw.length;
        if (this.keyEnd - bPtr != len) {
            return false;
        }
        int kPtr = 0;
        while (kPtr < len) {
            byte b;
            if (65 <= (b = this.buffer[bPtr++]) && b <= 90) {
                b = (byte)(b + 32);
            }
            if (b == kRaw[kPtr++]) continue;
            return false;
        }
        return true;
    }

    public String getKey() {
        return RawParseUtils.decode(this.enc, this.buffer, this.keyStart, this.keyEnd);
    }

    public String getValue() {
        return RawParseUtils.decode(this.enc, this.buffer, this.valStart, this.valEnd).replaceAll("\n +", " ");
    }

    public String getEmailAddress() {
        int lt = RawParseUtils.nextLF(this.buffer, this.valStart, '<');
        if (this.valEnd <= lt) {
            int at = RawParseUtils.nextLF(this.buffer, this.valStart, '@');
            if (this.valStart < at && at < this.valEnd) {
                return this.getValue();
            }
            return null;
        }
        int gt = RawParseUtils.nextLF(this.buffer, lt, '>');
        if (this.valEnd < gt) {
            return null;
        }
        return RawParseUtils.decode(this.enc, this.buffer, lt, gt - 1);
    }

    public int getStartOffset() {
        return this.keyStart;
    }

    public int getEndOffset() {
        return this.valEnd;
    }

    public String toString() {
        return this.getKey() + ": " + this.getValue();
    }
}

