/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.errors.MissingObjectException;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.internal.JGitText;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.lib.Constants;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevCommit;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.RevWalk;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.revwalk.filter.RevFilter;

public abstract class PatternMatchRevFilter
extends RevFilter {
    private final String patternText;
    private final Matcher compiledPattern;

    protected static final String forceToRaw(String patternText) {
        byte[] b = Constants.encode(patternText);
        StringBuilder needle = new StringBuilder(b.length);
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            needle.append((char)(element & 0xFF));
            ++n2;
        }
        return needle.toString();
    }

    protected PatternMatchRevFilter(String pattern, boolean innerString, boolean rawEncoding, int flags) {
        if (((String)pattern).length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.patternText = pattern;
        if (innerString) {
            if (!((String)pattern).startsWith("^") && !((String)pattern).startsWith(".*")) {
                pattern = ".*" + (String)pattern;
            }
            if (!((String)pattern).endsWith("$") && !((String)pattern).endsWith(".*")) {
                pattern = (String)pattern + ".*";
            }
        }
        String p = rawEncoding ? PatternMatchRevFilter.forceToRaw((String)pattern) : pattern;
        this.compiledPattern = Pattern.compile(p, flags).matcher("");
    }

    public String pattern() {
        return this.patternText;
    }

    @Override
    public boolean include(RevWalk walker, RevCommit cmit) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return this.compiledPattern.reset(this.text(cmit)).matches();
    }

    @Override
    public boolean requiresCommitBody() {
        return true;
    }

    protected abstract CharSequence text(RevCommit var1);

    @Override
    public String toString() {
        return super.toString() + "(\"" + this.patternText + "\")";
    }
}

