/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.NonNull;
import se.bjurr.violations.violationsgitlib.org.eclipse.jgit.annotations.Nullable;

public final class LsRefsV2Request {
    private final List<String> refPrefixes;
    private final boolean symrefs;
    private final boolean peel;
    @Nullable
    private final String agent;
    private final String clientSID;
    @NonNull
    private final List<String> serverOptions;

    private LsRefsV2Request(List<String> refPrefixes, boolean symrefs, boolean peel, @Nullable String agent, @NonNull List<String> serverOptions, @Nullable String clientSID) {
        this.refPrefixes = refPrefixes;
        this.symrefs = symrefs;
        this.peel = peel;
        this.agent = agent;
        this.serverOptions = Objects.requireNonNull(serverOptions);
        this.clientSID = clientSID;
    }

    public List<String> getRefPrefixes() {
        return this.refPrefixes;
    }

    public boolean getSymrefs() {
        return this.symrefs;
    }

    public boolean getPeel() {
        return this.peel;
    }

    @Nullable
    public String getAgent() {
        return this.agent;
    }

    @Nullable
    public String getClientSID() {
        return this.clientSID;
    }

    @NonNull
    public List<String> getServerOptions() {
        return this.serverOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<String> refPrefixes = Collections.emptyList();
        private boolean symrefs;
        private boolean peel;
        private final List<String> serverOptions = new ArrayList<String>();
        private String agent;
        private String clientSID;

        private Builder() {
        }

        public Builder setRefPrefixes(List<String> value) {
            this.refPrefixes = value;
            return this;
        }

        public Builder setSymrefs(boolean value) {
            this.symrefs = value;
            return this;
        }

        public Builder setPeel(boolean value) {
            this.peel = value;
            return this;
        }

        public Builder addServerOption(@NonNull String value) {
            this.serverOptions.add(value);
            return this;
        }

        public Builder setAgent(@Nullable String value) {
            this.agent = value;
            return this;
        }

        public Builder setClientSID(@Nullable String value) {
            this.clientSID = value;
            return this;
        }

        public LsRefsV2Request build() {
            return new LsRefsV2Request(Collections.unmodifiableList(this.refPrefixes), this.symrefs, this.peel, this.agent, Collections.unmodifiableList(this.serverOptions), this.clientSID);
        }
    }
}

