/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationsgitlib.org.eclipse.jgit.util;

import java.util.Arrays;

public class LongList {
    private long[] entries;
    private int count;

    public LongList() {
        this(10);
    }

    public LongList(int capacity) {
        this.entries = new long[capacity];
    }

    public int size() {
        return this.count;
    }

    public long get(int i) {
        if (this.count <= i) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.entries[i];
    }

    public boolean contains(long value) {
        int i = 0;
        while (i < this.count) {
            if (this.entries[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
    }

    public void add(long n) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = n;
    }

    public void set(int index, long n) {
        if (this.count < index) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.count == index) {
            this.add(n);
        } else {
            this.entries[index] = n;
        }
    }

    public void fillTo(int toIndex, long val) {
        while (this.count < toIndex) {
            this.add(val);
        }
    }

    public void sort() {
        Arrays.sort(this.entries, 0, this.count);
    }

    private void grow() {
        long[] n = new long[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, n, 0, this.count);
        this.entries = n;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append('[');
        int i = 0;
        while (i < this.count) {
            if (i > 0) {
                r.append(", ");
            }
            r.append(this.entries[i]);
            ++i;
        }
        r.append(']');
        return r.toString();
    }
}

