/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class MachineParser
implements ViolationsParser {
    private static final int ERROR_MESSAGE = 8;
    private static final int LENGTH = 7;
    private static final int COLUMN = 6;
    private static final int LINE = 5;
    private static final int FILE_PATH = 4;
    private static final int ERROR_CODE = 3;
    private static final int TYPE = 2;
    private static final int SEVERITY = 1;

    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "^([^\\|]+?)\\|([^\\|]+?)\\|([^\\|]+?)\\|([^\\|]+?)\\|([^\\|]+?)\\|([^\\|]+?)\\|([^\\|]+?)\\|(.+?)$");
        for (List<String> parts : partsPerLine) {
            String severity = parts.get(1);
            String type = parts.get(2);
            String errorCode = parts.get(3);
            String filePath = parts.get(4);
            String line = parts.get(5);
            String column = parts.get(6);
            String length = parts.get(7);
            String errorMessage = parts.get(8);
            violations.add(Violation.violationBuilder().setParser(Parser.MACHINE).setStartLine(Integer.parseInt(line)).setColumn(Integer.parseInt(column)).setEndColumn(Integer.parseInt(length)).setFile(filePath).setSeverity(this.toSeverity(severity)).setMessage(errorMessage).setRule(errorCode).setCategory(type).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return se.bjurr.violations.lib.model.SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return se.bjurr.violations.lib.model.SEVERITY.WARN;
        }
        return se.bjurr.violations.lib.model.SEVERITY.INFO;
    }
}

