/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.reports.Reporter;
import se.bjurr.violations.lib.util.StringUtils;

public class Utils {
    public static <T> T checkNotNull(T reference, String errorMessage) {
        if (reference == null) {
            throw new NullPointerException(errorMessage);
        }
        return reference;
    }

    public static String emptyToNull(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        return str;
    }

    public static String nullToEmpty(String nullableReference) {
        return nullableReference == null ? "" : nullableReference;
    }

    public static <T> T firstNonNull(T f, T s) {
        if (f != null) {
            return f;
        }
        return s;
    }

    public static InputStream getResource(String filename) {
        Thread.currentThread().getContextClassLoader();
        return ClassLoader.getSystemResourceAsStream(filename);
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String toString(InputStream inputStream) throws IOException {
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.displayName()).useDelimiter("\\A");
        String result = scanner.hasNext() ? scanner.next() : "";
        scanner.close();
        inputStream.close();
        return result;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"})
    public static String toString(URL resource) throws IOException {
        return Utils.toString(resource.openStream());
    }

    public static Set<Violation> setReporter(Set<Violation> violations, String reporter) {
        for (Violation v : violations) {
            v.setReporter(reporter);
        }
        return violations;
    }

    public static void updateReadmeWithReporters() throws IOException {
        String reporters = "";
        List sorted = Arrays.stream(Reporter.values()).sorted(Comparator.comparing(r1 -> r1.getName())).collect(Collectors.toList());
        for (Reporter reporter : sorted) {
            reporters = reporters + "| " + StringUtils.padRight("[_" + reporter.getName() + "_](" + reporter.getUrl() + ") ", 85) + " | " + StringUtils.padRight("`" + reporter.getParser().name() + "`", 20) + " | " + reporter.getNote().replace("|", "\\|") + "\n";
        }
        Path readmeFile = Utils.findReadmeFile(FileSystems.getDefault().getPath(".", new String[0]));
        if (readmeFile == null) {
            return;
        }
        String content = new String(Files.readAllBytes(readmeFile), StandardCharsets.UTF_8);
        String beginPart = "| Reporter | Parser | Notes";
        String endPart = "Missing a format? Open an issue [here](https://github.com/tomasbjerre/violations-lib/issues)!";
        int start = content.indexOf("| Reporter | Parser | Notes");
        if (start == -1) {
            throw new RuntimeException("Could not find:\n\n| Reporter | Parser | Notes\nMissing a format? Open an issue [here](https://github.com/tomasbjerre/violations-lib/issues)!\n\n in " + readmeFile.toString());
        }
        int end = content.indexOf("Missing a format? Open an issue [here](https://github.com/tomasbjerre/violations-lib/issues)!");
        String beforePart = content.substring(0, start + "| Reporter | Parser | Notes".length());
        String afterPart = content.substring(end);
        String reportersPart = reporters.trim();
        String stats = Parser.values().length + " parsers and " + Reporter.values().length + " reporters.";
        String newContent = beforePart + "\n| --- | --- | ---\n" + reportersPart + "\n\n" + stats + "\n\n" + afterPart;
        Files.write(readmeFile, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static Path findReadmeFile(Path file) throws IOException {
        if (file == null) {
            return null;
        }
        HashSet<Path> files = new HashSet<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(file);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                files.add(path);
            }
        }
        for (Path candidate : files) {
            Path fileName = candidate.getFileName();
            if (fileName == null || !fileName.toString().equals("README.md")) continue;
            return candidate;
        }
        return Utils.findReadmeFile(file.getParent());
    }
}

