/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.DetailedReportCreator;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.reports.ReportsFinder;
import se.bjurr.violations.lib.util.Utils;

public class ViolationsApi {
    private static Logger LOG = Logger.getLogger(ViolationsApi.class.getSimpleName());
    private String pattern;
    private Parser parser;
    private File startFile;
    private String reporter;

    public static String getDetailedReport(List<Violation> violations) {
        return new DetailedReportCreator(violations).create();
    }

    public static ViolationsApi violationsApi() {
        return new ViolationsApi();
    }

    private ViolationsApi() {
    }

    public ViolationsApi findAll(Parser parser) {
        this.parser = Utils.checkNotNull(parser, "parser");
        return this;
    }

    public ViolationsApi withReporter(String reporter) {
        this.reporter = Utils.checkNotNull(reporter, "reporter");
        return this;
    }

    public ViolationsApi inFolder(String folder) {
        this.startFile = new File(Utils.checkNotNull(folder, "folder"));
        if (!this.startFile.exists()) {
            throw new RuntimeException(folder + " not found");
        }
        return this;
    }

    public List<Violation> violations() {
        boolean reporterWasSupplied;
        List<File> includedFiles = ReportsFinder.findAllReports(this.startFile, this.pattern);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Found " + includedFiles.size() + " reports:");
            for (File f : includedFiles) {
                LOG.log(Level.FINE, f.getAbsolutePath());
            }
        }
        List<Violation> foundViolations = this.parser.findViolations(includedFiles);
        boolean bl = reporterWasSupplied = this.reporter != null && !this.reporter.trim().isEmpty() && !this.reporter.equals(this.parser.name());
        if (reporterWasSupplied) {
            Utils.setReporter(foundViolations, this.reporter);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Found " + foundViolations.size() + " violations:");
            for (Violation v : foundViolations) {
                LOG.log(Level.FINE, v.getReporter() + " " + (Object)((Object)v.getSeverity()) + " (" + v.getRule() + ") " + v.getFile() + " " + v.getStartLine() + " -> " + v.getEndLine());
            }
        }
        return foundViolations;
    }

    private String makeWindowsFriendly(String regularExpression) {
        return regularExpression.replace("/", "(?:/|\\\\)");
    }

    public ViolationsApi withPattern(String regularExpression) {
        this.pattern = this.makeWindowsFriendly(regularExpression);
        return this;
    }
}

