/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CLangParser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String reportContent) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "^([^:]+?):(\\d*):((\\d*?):)?([^:]*?)?: (.*)$");
        for (List<String> parts : partsPerLine) {
            String fileName = parts.get(1);
            Integer lineNumber = 0;
            if (!parts.get(2).isEmpty()) {
                lineNumber = Integer.parseInt(parts.get(2));
            }
            Integer columnNumber = 0;
            if (parts.get(3) != null && !parts.get(3).isEmpty() && parts.get(4) != null && !parts.get(4).isEmpty()) {
                columnNumber = Integer.parseInt(parts.get(4));
            }
            String severity = parts.get(5);
            String message = parts.get(6);
            violations.add(Violation.violationBuilder().setParser(Parser.CLANG).setStartLine(lineNumber).setColumn(columnNumber).setFile(fileName).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (Utils.isNullOrEmpty(severity)) {
            return SEVERITY.INFO;
        }
        if (severity.contains("error") || severity.contains("C")) {
            return SEVERITY.ERROR;
        }
        if (severity.contains("warning") || severity.contains("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

