/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.List;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class Flake8Parser
implements ViolationsParser {
    @Override
    public List<Violation> parseReportOutput(String string) throws Exception {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(string, "([^:]*):(\\d+)?:?(\\d*)?:? \\[?(\\D)(\\d*)\\]? (.*)");
        for (List<String> parts : partsPerLine) {
            String filename = parts.get(1);
            Integer line = Integer.parseInt(parts.get(2));
            Integer column = null;
            if (!Utils.isNullOrEmpty(parts.get(3))) {
                column = Integer.parseInt(parts.get(3));
            }
            String severity = parts.get(4);
            String rule = parts.get(5);
            String message = parts.get(6);
            violations.add(Violation.violationBuilder().setParser(Parser.FLAKE8).setStartLine(line).setColumn(column).setFile(filename).setRule(rule).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("E") || severity.equalsIgnoreCase("F")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

