/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.reports;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.AndroidLintParser;
import se.bjurr.violations.lib.parsers.CLangParser;
import se.bjurr.violations.lib.parsers.CPDParser;
import se.bjurr.violations.lib.parsers.CPPCheckParser;
import se.bjurr.violations.lib.parsers.CSSLintParser;
import se.bjurr.violations.lib.parsers.CheckStyleParser;
import se.bjurr.violations.lib.parsers.CodeNarcParser;
import se.bjurr.violations.lib.parsers.CppLintParser;
import se.bjurr.violations.lib.parsers.DocFXParser;
import se.bjurr.violations.lib.parsers.FindbugsParser;
import se.bjurr.violations.lib.parsers.Flake8Parser;
import se.bjurr.violations.lib.parsers.FxCopParser;
import se.bjurr.violations.lib.parsers.GendarmeParser;
import se.bjurr.violations.lib.parsers.GoLintParser;
import se.bjurr.violations.lib.parsers.GoogleErrorProneParser;
import se.bjurr.violations.lib.parsers.JCReportParser;
import se.bjurr.violations.lib.parsers.JSHintParser;
import se.bjurr.violations.lib.parsers.KlocworkParser;
import se.bjurr.violations.lib.parsers.LintParser;
import se.bjurr.violations.lib.parsers.MyPyParser;
import se.bjurr.violations.lib.parsers.PCLintParser;
import se.bjurr.violations.lib.parsers.PMDParser;
import se.bjurr.violations.lib.parsers.PerlCriticParser;
import se.bjurr.violations.lib.parsers.PiTestParser;
import se.bjurr.violations.lib.parsers.PyDocStyleParser;
import se.bjurr.violations.lib.parsers.PyLintParser;
import se.bjurr.violations.lib.parsers.ResharperParser;
import se.bjurr.violations.lib.parsers.SbtScalacParser;
import se.bjurr.violations.lib.parsers.SimianParser;
import se.bjurr.violations.lib.parsers.StyleCopParser;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.parsers.XMLLintParser;
import se.bjurr.violations.lib.parsers.YAMLlintParser;
import se.bjurr.violations.lib.parsers.ZPTLintParser;
import se.bjurr.violations.lib.util.Utils;

public enum Parser {
    ANDROIDLINT(new AndroidLintParser()),
    CHECKSTYLE(new CheckStyleParser()),
    CODENARC(new CodeNarcParser()),
    CLANG(new CLangParser()),
    CPD(new CPDParser()),
    CPPCHECK(new CPPCheckParser()),
    CPPLINT(new CppLintParser()),
    CSSLINT(new CSSLintParser()),
    FINDBUGS(new FindbugsParser()),
    FLAKE8(new Flake8Parser()),
    FXCOP(new FxCopParser()),
    GENDARME(new GendarmeParser()),
    JCREPORT(new JCReportParser()),
    JSHINT(new JSHintParser()),
    LINT(new LintParser()),
    KLOCWORK(new KlocworkParser()),
    MYPY(new MyPyParser()),
    GOLINT(new GoLintParser()),
    GOOGLEERRORPRONE(new GoogleErrorProneParser()),
    PERLCRITIC(new PerlCriticParser()),
    PITEST(new PiTestParser()),
    PMD(new PMDParser()),
    PYDOCSTYLE(new PyDocStyleParser()),
    PYLINT(new PyLintParser()),
    RESHARPER(new ResharperParser()),
    SBTSCALAC(new SbtScalacParser()),
    SIMIAN(new SimianParser()),
    STYLECOP(new StyleCopParser()),
    XMLLINT(new XMLLintParser()),
    YAMLLINT(new YAMLlintParser()),
    ZPTLINT(new ZPTLintParser()),
    DOCFX(new DocFXParser()),
    PCLINT(new PCLintParser());

    private static Logger LOG;
    private transient ViolationsParser violationsParser;

    private Parser(ViolationsParser violationsParser) {
        this.violationsParser = violationsParser;
    }

    public List<Violation> findViolations(List<File> includedFiles) {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (File file : includedFiles) {
            try {
                String string = Utils.toString(new FileInputStream(file));
                violations.addAll(this.violationsParser.parseReportOutput(string));
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Error when parsing " + file.getAbsolutePath() + " as " + this.name(), e);
            }
        }
        return violations;
    }

    public ViolationsParser getViolationsParser() {
        return this.violationsParser;
    }

    static {
        LOG = Logger.getLogger(Parser.class.getSimpleName());
    }
}

